<?php
/**
 * @package     ganesa
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

class ganesa_carousel_post extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'carousel_post',esc_html__('+NA: Carousel Posts','ganesa'),
            array('description'=>esc_html__('Carousel Posts', 'ganesa'))
        );
    }

    public function widget( $args, $instance ) {
        extract( $args );
        $number     = $instance['number'];
        $show       = $instance['show'];
        $dates = $instance['dates'];
        $type_post = $instance['type_post'];
        $categories = $instance['categories'];

        $title = apply_filters('widget_title', $instance['title']);
        $arr2=array();
        $arr = array(
            'category_name' => $categories,
            'showposts'     => $number,
            'post_type'     => 'post',
            'post_status'   => 'publish',
            'orderby'       => 'date',
            'order'         => 'DESC',
        );

        if( $type_post == 'featured' ){
            $meta_query[] = array(
                'key'   => '_featured',
                'value' => 'yes'
            );
            $arr['meta_query'] = $meta_query;
        }
        if( $type_post == 'views' ){
            $arr2 = array(
                'meta_key'      => 'post_views_count',
                'orderby'       =>'meta_value_num',
                'date_query'    => array( array( 'after' =>  $dates ) ),
            );

        }
        $att=array_merge($arr,$arr2);
        $add_rtl="false";
        if(is_rtl()){
            $add_rtl="true";
        }
        $popular_posts = new WP_Query( $att);

        echo ent2ncr($args['before_widget']);
        if($title) {
            echo ent2ncr($args['before_title']) . esc_html($title) . ent2ncr($args['after_title']);
        }
        ?>

        <!-- Tab panes -->
        <div class="archive-blog article-carousel widget-carousel" data-rtl="<?php echo esc_attr($add_rtl);?>"  data-table="1" data-number="<?php echo esc_attr($show);?>" data-mobile = "1" data-mobilemin = "1" data-dots="true" data-arrows="false">
            <?php
            if($popular_posts->have_posts()): ?>
                    <?php while($popular_posts->have_posts()): $popular_posts->the_post(); ?>
                    <?php get_template_part( 'templates/layout/content-trans-vertical'); ?>
                    <?php endwhile; wp_reset_postdata(); ?>
            <?php endif; ?>
        </div>
        <?php
        echo ent2ncr($args['after_widget']);
    }
// Widget Backend
    public function form( $instance ) {
        $instance = wp_parse_args($instance,array(
            'title'         => esc_html__('Most Popular','ganesa'),
            'number'        => '3',
            'show'          => '1',
            'type_post'     => 'news',
            'dates'         => '-2 year',
            'categories'    => '',
        ));
        // Widget admin form
        ?>
        <p>
            <label for=<?php echo esc_attr($this->get_field_id('title')); ?>><?php echo esc_html_e('Title:','ganesa') ; ?></label>
            <input type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php echo esc_html_e('Show posts:','ganesa'); ?></label>
            <input type="text" id="<?php echo esc_attr($this->get_field_id('show')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('show')); ?>" value="<?php echo esc_attr($instance['show']); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php echo esc_html_e('Number posts:','ganesa'); ?></label>
            <input type="text" id="<?php echo esc_attr($this->get_field_id('number')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('number')); ?>" value="<?php echo esc_attr($instance['number']); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Categories:', 'ganesa') ?></label>
            <select id="<?php echo esc_attr($this->get_field_id('categories')); ?>" name="<?php echo esc_attr($this->get_field_name('categories')); ?>" class="widefat categories">
                <option value='' <?php if ('' == $instance['categories']) echo 'selected="selected"'; ?>><?php  esc_html_e('All categories', 'ganesa'); ?></option>
                <?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
                <?php foreach($categories as $category) { ?>
                    <option value='<?php echo esc_attr($category->slug); ?>' <?php if ($category->slug == $instance['categories']) echo 'selected="selected"'; ?>><?php echo esc_html($category->cat_name); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('type_post')); ?>">
                <strong><?php esc_html_e('Type Post', 'ganesa') ?>:</strong>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('type')); ?>"
                        name="<?php echo esc_attr($this->get_field_name('type_post')); ?>">
                    <option
                        value="news"<?php echo (isset($instance['type_post']) && $instance['type_post'] == 'news') ? ' selected="selected"' : '' ?>><?php esc_html_e('News', 'ganesa') ?>
                    </option>
                    <option
                        value="views"<?php echo (isset($instance['type_post']) && $instance['type_post'] == 'views') ? ' selected="selected"' : '' ?>><?php esc_html_e('Most Views', 'ganesa') ?>
                    </option>
                    <option
                        value="featured"<?php echo (isset($instance['type_post']) && $instance['type_post'] == 'featured') ? ' selected="selected"' : '' ?>><?php esc_html_e('Featured', 'ganesa') ?>
                    </option>

                </select>
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('dates')); ?>">
                <strong><?php esc_html_e('Most popular post for', 'ganesa') ?>:</strong>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('type')); ?>"
                        name="<?php echo esc_attr($this->get_field_name('dates')); ?>">
                    <option
                        value="-1 days"<?php echo (isset($instance['dates']) && $instance['dates'] == '-1 week') ? ' selected="selected"' : '' ?>><?php esc_html_e('Last Week', 'ganesa') ?></option>
                    <option
                        value="-2 week"<?php echo (isset($instance['dates']) && $instance['dates'] == '-2 week') ? ' selected="selected"' : '' ?>><?php esc_html_e('Two Weeks ago', 'ganesa') ?></option>
                    <option
                        value="-1 month"<?php echo (isset($instance['dates']) && $instance['dates'] == '-1 month') ? ' selected="selected"' : '' ?>><?php esc_html_e('Last Month', 'ganesa') ?></option>
                    <option
                        value="-2 year"<?php echo (isset($instance['dates']) && $instance['dates'] == '-2 year') ? ' selected="selected"' : '' ?>><?php esc_html_e('Last Years', 'ganesa') ?></option>
                </select>
            </label>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title']      = $new_instance['title'];
        $instance['show']       = $new_instance['show'];
        $instance['number']     = $new_instance['number'];
        $instance['type_post']  = $new_instance['type_post'];
        $instance['dates']      = $new_instance['dates'];
        $instance['categories'] = $new_instance['categories'];
        return $instance;
    }
}
function ganesa_carousel_post(){
    register_widget('ganesa_carousel_post');
}
add_action('widgets_init','ganesa_carousel_post');