<?php

if (!function_exists('na_shortcode_info_about')) {
    function na_shortcode_info_about($atts,$output)
    {
        $atts = shortcode_atts(
            array(
                'image_f'     => '',
                'des_f'       => 'NanoAgency Theme 2018',
                'title_box'     => 'Designed for men, Just for you.',
                'content_box'   => '',
                'image_t'       => '',
                'box_layouts'   => 'style-1',
                'items'         => '',
                'css' => '',

            ), $atts);

        ob_start();
            nano_template_part('shortcode', 'info-about' , array('atts' => $atts));?>
            <?php
            $output = ob_get_contents();
        ob_end_clean();

        return $output;
    }
}

add_shortcode('na_info_about', 'na_shortcode_info_about');

add_action('vc_before_init', 'na_info_about_integrate_vc');

if (!function_exists('na_info_about_integrate_vc')) {
    function na_info_about_integrate_vc()
    {
        vc_map(
            array(
                'name' => esc_html__('NA: About Me', 'nano'),
                'base' => 'na_info_about',
                'icon' => 'icon-infoAbout',
                'category' => esc_html__('NA', 'nano'),
                'description' => esc_html__('About Me ', 'nano'),
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__('Highlights photos', 'nano'),
                        'value' => '',
                        'description' => esc_html__( 'Select images from media library. Default to use 570x700 size.', 'nano' ),
                        'param_name' => 'image_f',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__('Description for highlights photos ', 'nano'),
                        'value' => esc_html('NanoAgency Theme 2018'),
                        'param_name' => 'des_f',
                    ),

                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__('Title', 'nano'),
                        'value' => esc_html('Designed for men, Just for you.'),
                        'param_name' => 'title_box',
                    ),

                    array(
                        "type" => "textarea",
                        "class" => "",
                        "heading" => esc_html__('Description','nano'),
                        "param_name" => "content_box",
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__('Description photos', 'nano'),
                        'value' => '',
                        'description' => esc_html__( 'Select images from media library.Default to use 600x600 size.', 'nano' ),
                        'param_name' => 'image_t',
                    ),
                    array(
                        'type' => 'param_group',
                        'heading' => esc_html__('Social Setting', 'nano' ),
                        'param_name' => 'items',
                        'group' => __( 'Add Social', 'nano' ),
                        'params' => array(
                            array(
                                'type' => 'iconpicker',
                                'heading' => __( 'Icon', 'nano' ),
                                'param_name' => 'icon',
                                'value' => 'fa fa-adjust',
                                'admin_label' => true,
                                'settings' => array(
                                    'emptyIcon' => false,
                                    'iconsPerPage' => 4000,
                                ),
                                'dependency' => array(
                                    'element' => 'type',
                                    'value' => 'fontawesome',
                                ),
                                'description' => esc_html__( 'Select icon from library.', 'nano' ),
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'URL (Link) Social', 'nano' ),
                                'param_name' => 'link',
                                'description' => esc_html__( 'Add link to button (Important: adding link automatically adds button).', 'nano' ),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'nano' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'nano' ),
                    ),
                )
            )
        );
    }
}