<?php
/**
 * The default template for displaying content
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */
$format = get_post_format();
$add_class=$class='';
$args = array(
    'category_name'  => $atts['category_name'],
    'post_type'      => 'post',
    'post_status'    => 'publish',
    'posts_per_page' => $atts['number_post'],
);


if( $atts['type_post'] == 'featured' ){
    $meta_query[] = array(
        'key' => '_featured',
        'value' => 'yes'
    );
    $args['meta_query'] = $meta_query;
}

$arr2=array();
if( $atts['type_post'] == 'views' ){
    $arr2 = array(
        'meta_key'      => 'post_views_count',
        'orderby'       =>'meta_value_num',
        'order'         =>'DESC',
        'date_query' => array( array( 'after' =>  $atts['dates'] ) ),
    );
}

switch ($atts['columns']) {
    case '2':
        $class .= "col-xs-6 col-sm-6 col-md-6";
        break;
    case '3':
        $class .= "col-xs-12 col-sm-4 col-md-4";
        break;
    case '4':
        $class .= "col-xs-6 col-sm-6 col-md-3";
        break;
    default:
        $class .= "col-xs-6 col-sm-6 col-md-6";
        break;
}
$att=array_merge($args,$arr2);
$the_query = new WP_Query($att);
$count = $the_query->found_posts;
$num_pages = $the_query->max_num_pages;

if(isset($atts['category_name']) & !empty($atts['category_name'])){
    $categories = explode( ',', $atts['category_name'] );
} else{
    $categories=get_the_category();
}

?>

<?php
switch ($atts['layout_types']) {

    case 'box1':?>
        <?php $rand = rand(0,99);?>
        <div class="box-cats box wrapper-posts  layout-box1" data-layout="box1" data-typePost="<?php echo esc_attr($atts['type_post']);?>"  data-dates="<?php echo esc_attr($atts['dates']);?>"  data-paged="<?php echo esc_attr($num_pages);?>" data-col="<?php echo esc_attr($class);?>" data-cat="<?php echo esc_attr($atts['category_name'])?>" data-number="<?php echo esc_attr($atts['number_post'])?>">

            <?php if ($atts['title'] && $atts['title_style'] != 'inside') { ?>
                <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                    <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                    <?php if ($atts['cat_link']) { ?>
                        <a class="btn-more" title="" href="<?php echo esc_url($atts['cat_link']); ?>"><?php echo esc_html__('Read More','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                    <?php } ?>
                </div>
            <?php } ?>

            <span class="agr-loading"></span>
            <div class="tab-content">
                <div class="box-blog archive-blog active row large-vertical clearfix">

                    <?php if ($atts['title'] && $atts['title_style'] == 'inside') { ?>
                        <div class="col-item post-item  item-title <?php echo esc_html($class);?>">
                            <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                                <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                                <?php if ($atts['cat_link']) { ?>
                                    <a class="btn-more" title="" href="<?php echo esc_url($atts['cat_link']); ?>"><?php echo esc_html__('Read More','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>

                    <?php  while ( $the_query->have_posts() ) {
                        $the_query->the_post(); ?>
                        <div class="col-item  <?php echo esc_html($class);?> hidden-description">
                            <?php na_part_templates('layout/content-grid'); ?>
                        </div>
                    <?php } wp_reset_postdata();?>
                </div>

            </div>
        </div>
        <?php break;

    case 'box2':?>
        <?php $rand = rand(0,99);?>
        <div class="box-cats box wrapper-posts layout-box2 style-<?php echo esc_attr($atts['title_style']);?>">

            <div class="content-category cats-grid-des">
                <div class="rows affect-isotope clearfix">

                        <div class="item-post col-item item-grid-des col-item-title item-title">

                            <?php if ($atts['title']) { ?>
                                <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                            <?php } ?>
                            <?php if ($atts['cat_link']) { ?>
                                <a class="btn-more" title="" href="<?php echo esc_url($atts['cat_link']); ?>"><?php echo esc_html__('Read More','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                            <?php } ?>
                        </div>
                    <?php
                    if ($the_query->have_posts()):
                        $n=1;
                        while ($the_query->have_posts()): $the_query->the_post(); ?>
                            <?php if($n%5==0):?>
                                <div class="item-post col-item item-grid-list clearfix">
                                    <?php get_template_part( 'templates/layout/content-list'); ?>
                                </div>
                            <?php elseif(($n-1)%5==0 || ($n-2)%5==0):?>
                                <div class="item-post col-item item-grid-des nano-left">
                                    <?php get_template_part( 'templates/layout/content-grid-des'); ?>
                                </div>
                            <?php else:?>
                                <div class="item-post col-item item-grid-des">
                                    <?php get_template_part( 'templates/layout/content-grid-des'); ?>
                                </div>
                            <?php endif;?>
                            <?php $n++; endwhile;
                    endif;
                    wp_reset_postdata(); ?>
                </div>
            </div>

        </div>
        <?php break;
    case 'box3':?>
        <?php $rand = rand(0,99);?>
        <div class="box-cats box wrapper-posts layout-box3">
            <div class="box-title">
                <?php if ($atts['title']) { ?>
                        <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                <?php } ?>
                <?php if ($atts['cat_link']) { ?>
                    <a class="btn-more" title="" href="<?php echo esc_url($atts['cat_link']); ?>"><?php echo esc_html__('Read More','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                <?php } ?>
            </div>
            <div class="content-category cats-grid">
                <div class="rows affect-isotope clearfix">
                    <?php
                    if ($the_query->have_posts()):
                        $n=1;
                        while ($the_query->have_posts()): $the_query->the_post(); ?>
                            <?php if($n==2):?>
                                <div class="item-post col-item item-grid-vertical">
                                    <?php get_template_part( 'templates/layout/content-grid-vertical'); ?>
                                </div>
                            <?php else:?>
                                <div class="item-post col-item item-grid-des">
                                    <?php get_template_part( 'templates/layout/content-grid'); ?>
                                </div>
                            <?php endif;?>
                            <?php $n++; endwhile;
                    endif;
                    wp_reset_postdata(); ?>
                </div>
            </div>

        </div>
        <?php break;

    default:?>
        <?php $rand = rand(0,99);?>
        <div class="box-cats box wrapper-posts layout-box1" data-layout="box1" data-typePost="<?php echo esc_attr($atts['type_post']);?>"  data-dates="<?php echo esc_attr($atts['dates']);?>"  data-paged="<?php echo esc_attr($num_pages);?>" data-col="<?php echo esc_attr($class);?>" data-cat="<?php echo esc_attr($atts['category_name'])?>" data-number="<?php echo esc_attr($atts['number_post'])?>">
            <div class="box-title">
                <?php if ($atts['title']) { ?>
                    <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                <?php } ?>
                <?php if ($atts['cat_link']) { ?>
                    <a class="btn-more" title="" href="<?php echo esc_url($atts['cat_link']); ?>"><?php echo esc_html__('Read More','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                <?php } ?>
            </div>
            <span class="agr-loading"></span>
            <div class="tab-content">
                <div class="box-blog archive-blog active row large-vertical clearfix">
                    <?php  while ( $the_query->have_posts() ) {
                        $the_query->the_post(); ?>
                        <div class="col-item  <?php echo esc_html($class);?> hidden-description">
                            <?php na_part_templates('layout/content-grid'); ?>
                        </div>
                    <?php } wp_reset_postdata();?>
                </div>

            </div>
        </div>
        <?php break;
}
?>