<?php


$css_class          = vc_shortcode_custom_css_class( $atts['css'], ' ' );
$items              = (array) vc_param_group_parse_atts($atts['items']);
$image_size         = array(447,250);
?>
<div class="block block-banner-category">
    <div class="block-title  clearfix">
        <?php if ( $atts['title'] ) {?>
            <h3 class="title-block">
                <?php echo esc_html( $atts['title'] ); ?>
            </h3>
        <?php }?>
    </div>
    <div class="block-content box-banner-category clearfix">
        <div class="article-carousel" data-rtl="false"  data-table="3" data-number="3" data-mobile = "2" data-mobilemin = "2" data-dots="false" data-arrows="false">

            <?php foreach ( $items as $item ) {?>
                <div class="banner-category-box col-item clearfix">
                    <?php if($item['image_box']) { ?>
                        <div class="box-image">
                            <a href="<?php echo esc_url($item['link_box']); ?>">
                                <?php echo wp_get_attachment_image($item['image_box'], $image_size); ?>
                            </a>
                        </div>
                    <?php } ?>
                    <div class="box-content clearfix">
                        <div class="box-content-inner">
                            <?php
                            if($item['title_box']){?>
                                <h3 class="title-box"><a href="<?php echo esc_url($item['link_box']); ?>"><?php echo esc_html($item['title_box']); ?></a></h3>
                            <?php }?>
                        </div>
                    </div>
                </div>
            <?php  }?>

        </div>
    </div>
</div>