<?php
/**
 * Single Post
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */

get_header();

$add_rtl="false";
if(is_rtl()){
	$add_rtl="true";
}

$image_meta         = get_theme_mod('ganesa_image_meta',true);

?>
<div class="wrap-content single-full" role="main">
	<div class="container">
		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();?>

		<?php endwhile; ?>
		<div class="row single-main-content">
            <div class="main-content content-full col-sx-12 col-sm-12 col-md-12 col-lg-12">
			    <div class="content-inner">
				<?php
				// Start the loop.
				while ( have_posts() ) : the_post();?>
					<div class="box box-article">
						<article id="post-<?php the_ID(); ?>" <?php  post_class();?>>
							<div class="entry-header clearfix">
								<header class="entry-header-title">
									<?php  the_title( '<h1 class="entry-title">', '</h1>' ); ?>
								</header>
								<!-- .entry-header -->
								<?php if(get_theme_mod('ganesa_avatar_meta',true)):?>
									<div class="entry-avatar clearfix">
                                        <div class="avatar-image">
                                            <?php
                                            $author_bio_avatar_size = apply_filters( 'ganesa_author_bio_avatar_size', 50 );
                                            echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
                                            ?>
                                        </div>
										<div class="avatar-meta">
                                                <span class="author-title">
                                                    <a class="author-link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
                                                        <?php echo esc_attr(get_the_author()); ?>
                                                    </a>
                                                </span>
                                                <span class="post-date">
                                                <?php if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
                                                    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

                                                    if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
                                                        $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
                                                    }

                                                    $time_string = sprintf( $time_string,
                                                        esc_attr( get_the_date( 'c' ) ),
                                                        get_the_date(),
                                                        esc_attr( get_the_modified_date( 'c' ) ),
                                                        get_the_modified_date()
                                                    );

                                                    printf( '<span class="posted-on"><span class="screen-reader-text">%1$s </span><a href="%2$s" rel="bookmark">%3$s</a></span>',
                                                        _x( 'Posted on', 'Used before publish date.', 'ganesa' ),
                                                        esc_url( get_permalink() ),
                                                        $time_string
                                                    );
                                                }
                                                ?>
                                                </span>
										</div>
									</div>
								<?php endif;?>

							</div>

							<?php if(has_post_format('gallery') & $image_meta) : ?>
								<?php $images = get_post_meta( $post->ID, '_format_gallery_images', true ); ?>
								<?php if($images) : ?>
									<div class="post-image single-image">
										<ul class="owl-single">
											<?php foreach($images as $image) : ?>
												<?php $the_image = wp_get_attachment_image_src( $image, 'ganesa-single' ); ?>
												<?php $the_caption = get_post_field('post_excerpt', $image); ?>
												<li><img src="<?php echo esc_url($the_image[0]); ?>" <?php if($the_caption) : ?>title="<?php echo esc_attr($the_caption); ?>"<?php endif; ?> /></li>
											<?php endforeach; ?>
										</ul>
									</div>
								<?php endif; ?>

							<?php elseif(has_post_format('video') & $image_meta) : ?>

								<div class="embed-responsive single-image embed-responsive-16by9 post-video single-video embed-responsive embed-responsive-16by9">
									<?php $sp_video = get_post_meta( get_the_ID(), '_format_video_embed', true ); ?>
									<?php if(wp_oembed_get( $sp_video )) : ?>
										<?php echo wp_oembed_get($sp_video); ?>
									<?php else : ?>
										<?php echo esc_url($sp_video); ?>
									<?php endif; ?>
								</div>

							<?php elseif(has_post_format('audio') & $image_meta ) : ?>

								<div class="post-image audio single-image single-audio">
									<?php $sp_audio = get_post_meta( $post->ID, '_format_audio_embed', true ); ?>
									<?php if(wp_oembed_get( $sp_audio )) : ?>
										<?php echo wp_oembed_get($sp_audio); ?>
									<?php else : ?>
										<?php echo str_replace('','', $sp_audio); ?>
									<?php endif; ?>
								</div>

							<?php else : ?>
								<?php if(has_post_thumbnail() & $image_meta ) : ?>
									<?php if(!get_theme_mod('sp_post_thumb')) : ?>
										<div class="post-image single-image">
											<?php $thumbnail_full = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "full" ); ?>
											<?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "ganesa-single" ); ?>
											<figure class="wp-single-image">
												<a href="<?php echo esc_attr($thumbnail_full[0]);?>" data-size="<?php echo esc_attr($thumbnail_full[1]); ?>x<?php echo esc_attr($thumbnail_full[2]); ?>">
													<img  class="wp-post-image" src="<?php echo esc_attr($thumbnail_src[0]);?>" alt="<?php echo esc_attr('single-image')?>"/>
												</a>
											</figure>
										</div>
									<?php endif; ?>
								<?php endif; ?>
							<?php endif; ?>

							<div class="entry-content clearfix">
								<?php ganesa_excerpt(); ?>
								<div class="entry-content-inner">
									<?php

									the_content();

									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'ganesa' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span class="page-numbers">',
										'link_after'  => '</span>',
										'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'ganesa' ) . ' </span>%',
										'separator'   => '<span class="screen-reader-text">, </span>',
									) );

									?>

								</div>
							</div>

							<!--    Author bio.-->
							<div class="entry-footer clearfix">
								<div class="entry-footer-left">
									<?php get_template_part('templates/tag'); ?>
								</div>
                                <div class="share-bottom">
                                    <?php get_template_part('templates/share-social'); ?>
                                </div>
							</div>
						</article>
					</div>
				<?php  get_template_part( 'content','single' );?>
				<?php endwhile; ?>
			</div>
            </div>

		</div><!-- .content-area -->
	</div>
</div>
<?php get_footer(); ?>

