<?php
/**
 * The default template for displaying content
 *
 * @author      Nanoganesa
 * @link        http://nanoganesa.co
 * @copyright   Copyright (c) 2015 Nanoganesa
 * @license     GPL v2
 */
$format = get_post_format();
$placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-blog-hafl.jpg';
$thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "full" );
$bg_image="background-image:url('$thumbnail_src[0]')";
?>

    <article <?php post_class('post-item  posts-half clearfix '); ?>>
        <div class="article-image post-half">
                <?php if(has_post_thumbnail()) : ?>
                    <?php if(!get_theme_mod('sp_post_thumb')) :?>
                        <div class="post-image lazy" style = "<?php echo esc_attr($bg_image);?>">
                            <a href="<?php echo get_permalink() ?>"></a>
                        </div>
                    <?php endif; ?>
                <?php else :
                    $placeholder_image = get_template_directory_uri(). '/assets/images/placeholder-box.png';
                    ?>
                    <div class="post-image  placeholder-trans ">
                        <a href="<?php echo get_permalink() ?>"><?php the_post_thumbnail('full'); ?>
                            <img src="<?php echo esc_url($placeholder_image); ?>" class="wp-post-image" width="1170" height="500">
                        </a>
                    </div>
                <?php endif; ?>
                <div class="article-content">
                    <div class="entry-header clearfix">
                        <header class="entry-header-title">
                            <?php
                            the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                            ?>
                        </header>
                        <span class="post-cat"><?php echo ganesa_category(', '); ?></span>
                        <div class="article-meta clearfix">
                            <?php ganesa_entry_meta(); ?>
                        </div>

                    </div>
                    <div class="entry-content">
                        <?php
                        if ( has_excerpt() || is_search() ){
                            ganesa_excerpt();
                        }
                        else{
                            echo ganesa_content(18);
                        }
                        ?>
                    </div>
                    <a  class="btn-read" href="<?php echo get_permalink() ?>"><?php echo esc_html__('Read More','ganesa')?></a>

                </div>
        </div>
    </article><!-- #post-## -->
<!--<a href="--><?php //echo esc_url(comments_link());?><!--" class="text-comment">-->