<?php
/**
 * The default template for displaying content
 *
 * @author      Nanoganesa
 * @link        http://nanoganesa.co
 * @copyright   Copyright (c) 2015 Nanoganesa
 * @license     GPL v2
 */
$format = get_post_format();
$placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-grid-vertical.jpg';
?>

<article <?php post_class('post-item post-grid clearfix'); ?>>
    <div class="article-tran hover-share-item">
        <?php if(has_post_thumbnail()) : ?>
            <?php if(!get_theme_mod('sp_post_thumb')) : ?>
                <?php if(has_post_thumbnail()) : ?>
                    <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "ganesa-blog-grid-vertical" ); ?>
                    <div class="post-image">
                        <a href="<?php echo get_permalink() ?>" class="bgr-item"></a>
                        <a href=" <?php echo get_permalink() ?>">
                            <img  class="lazy" src="<?php echo esc_url($placeholder_image);?>"  data-lazy="<?php echo esc_attr($thumbnail_src[0]);?>" data-src="<?php echo esc_attr($thumbnail_src[0]);?>" alt="<?php echo esc_attr('post-image')?>"/>
                        </a>
                        <?php ganesa_entry_meta_left(); ?>
                    </div>
                <?php endif;?>
                <div class="article-content">
                    <div class="entry-header clearfix">
                        <header class="entry-header-title">
                            <?php
                            the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                            ?>
                        </header>
                        <span class="post-cat"><?php echo ganesa_category(', '); ?></span>
                        <div class="article-meta clearfix">
                            <?php ganesa_entry_meta(); ?>
                        </div>
                        <div class="entry-content hidden">
                            <?php echo ganesa_content(18);

                            wp_link_pages( array(
                                'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'ganesa' ) . '</span>',
                                'after'       => '</div>',
                                'link_before' => '<span class="page-numbers">',
                                'link_after'  => '</span>',
                                'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'ganesa' ) . ' </span>%',
                                'separator'   => '<span class="screen-reader-text">, </span>',
                            ) );
                            ?>

                        </div>
                    </div>

                </div>
            <?php endif; ?>
        <?php else :
            $placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-tran.jpg';
            ?>
            <div class="post-image  placeholder-trans">
                <?php ganesa_entry_meta_left(); ?>
            </div>
            <div class="article-content no-thumb">

                <div class="entry-header clearfix">
                    <header class="entry-header-title">
                        <?php
                        the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                        ?>
                    </header>
                </div>
                <span class="post-cat"><?php echo ganesa_category(' '); ?></span>
                <div class="article-meta clearfix">
                    <?php ganesa_entry_meta(); ?>
                </div>
                <div class="entry-content">
                    <?php
                    if ( has_excerpt() || is_search() ){
                        ganesa_excerpt();
                    }
                    else{
                        echo ganesa_content(25);
                    }


                    wp_link_pages( array(
                        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'ganesa' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span class="page-numbers">',
                        'link_after'  => '</span>',
                        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'ganesa' ) . ' </span>%',
                        'separator'   => '<span class="screen-reader-text">, </span>',
                    ) );
                    ?>

                </div>
            </div>
        <?php endif; ?>
    </div>

</article><!-- #post-## -->
