<?php
/**
 * @package     ganesa
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

if (class_exists('WPBakeryVisualComposerAbstract')) {

    function ganesa_vc_templates( $default_templates ) {
        // New templates
        $new_templates = array(
            'templates-home-main' => array(
                'name' 			=> esc_html__( 'Home Main', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home1.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content" css=".vc_custom_1544021165104{background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column][top_blog layout_types="box" type_post="yes" title="Todays News" category_name=""][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][blog_featured meta="" title="Trending Posts" category_name=""][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1543944586924{margin-top: 30px !important;}"][vc_column][blog title_style="center" post_layout="grid" number="14" style_border="yes" filter="yes" type_filter="" list_type="" columns="2" title="Latest News" category_name=""][/vc_column][/vc_row]'
            ),
            'templates-home-journal' => array(
                'name' 			=> esc_html__( 'Home Journal', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home2.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content"][vc_column][top_blog layout_types="box" category_name=""][/vc_column][/vc_row][vc_row][vc_column][box_video title_style="inside" title="Hot Videos"][/vc_column][/vc_row][vc_row][vc_column][box_category type_post="news" layout_types="box2" number_post="4" category_name="" title="Fashion" cat_link="#"][/vc_column][/vc_row][vc_row][vc_column][box_category type_post="news" layout_types="box2" number_post="4" category_name="" cat_link="#"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-12"][blog title_style="center" post_layout="grid" number="13" style_border="yes" category_name="" title=" Latest News "][/vc_column][/vc_row]'
            ),
            'templates-home-masonry' => array(
                'name' 			=> esc_html__( 'Home Masonry', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home3.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content"][vc_column][blog title_style="inside" post_layout="trans" number="17" image_box="1996" filter="" title="My Blog" category_name=""][/vc_column][/vc_row]'
            ),
            'templates-home-minimal-blog' => array(
                'name' 			=> esc_html__( 'Home Minimal Blog', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home3.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1544092300711{background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column][na_intro_images image_box="2132" items="%5B%7B%22image_box%22%3A%222081%22%2C%22title_box%22%3A%22Tell%20your%20story%22%2C%22content_box%22%3A%22Aenean%20sollicitudin%2C%20lorem%20quis%20bibendum%20auctor.%22%2C%22link_box%22%3A%22%23%22%7D%2C%7B%22image_box%22%3A%222081%22%2C%22title_box%22%3A%22a%22%2C%22content_box%22%3A%22asdsa%22%2C%22link_box%22%3A%22%23%22%7D%2C%7B%22image_box%22%3A%222081%22%2C%22title_box%22%3A%22a%22%2C%22content_box%22%3A%22asdsa%22%2C%22link_box%22%3A%22%23%22%7D%5D" title_box="Tell your story" content_box="I make lovely things in order to fill my little house in my spare time."][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1543850324658{margin-top: 30px !important;}"][vc_column][blog_featured title="Treding Posts" category_name=""][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1543998359250{margin-top: 30px !important;}"][vc_column width="12/12"][blog post_layout="grid" number="13" style_border="" category_name=""][/vc_column][/vc_row]'
            ),
            'templates-home-modern' => array(
                'name' 			=> esc_html__( 'Home Modern', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home3.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row][vc_column][na_info_about image_f="2167" des_f="Nanos Blog 2019" title_box="Life Events Blog Posts" image_t="1996" box_layouts="style-2" content_box=" Lorem ipsum dolor sit amet consectetur adipiscing elit. Phasellus dignissim purus facilisis libero suscipit vulputate.Vestibulum rutrum velit" items="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-pinterest%22%2C%22link%22%3A%22%23%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column][box_video layout_types="carousel" number_post="5" auto_play=""][/vc_column][/vc_row][vc_row css=".vc_custom_1544002631828{margin-top: 30px !important;}"][vc_column][blog post_layout="grid-des" number="10" category_name="" title="Blog Posts"][/vc_column][/vc_row]'
            ),
            'templates-home-simple-blog' => array(
                'name' 			=> esc_html__( 'Home Simple Blog', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home3.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row css=".vc_custom_1544020987815{background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column][top_blog layout_types="column1" type_post="yes" number_post="6" category_name=""][/vc_column][/vc_row][vc_row][vc_column][na_banner_category items="%5B%7B%22image_box%22%3A%221997%22%2C%22title_box%22%3A%22Tips%20%26%20Tricks%22%2C%22link_box%22%3A%22http%3A%2F%2Flocalhost%2Fwp%2Fwp-ganesa%2Fcategory%2Ftips-tricks%2F%22%7D%2C%7B%22image_box%22%3A%221999%22%2C%22title_box%22%3A%22Fashion%20%26%20Style%22%2C%22link_box%22%3A%22http%3A%2F%2Flocalhost%2Fwp%2Fwp-ganesa%2Fcategory%2Ffashion-style%2F%22%7D%2C%7B%22image_box%22%3A%221996%22%2C%22title_box%22%3A%22Lifestyle%22%2C%22link_box%22%3A%22http%3A%2F%2Flocalhost%2Fwp%2Fwp-ganesa%2Fcategory%2Flifestyle%2F%22%7D%2C%7B%22image_box%22%3A%221878%22%2C%22title_box%22%3A%22Travel%22%2C%22link_box%22%3A%22%23%22%7D%2C%7B%22image_box%22%3A%222000%22%2C%22title_box%22%3A%22Fashion%22%2C%22link_box%22%3A%22%23%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1543393732482{padding-right: 65px !important;}" offset="vc_col-lg-9 vc_col-md-12"][blog number="9" filter="" category_name=""][/vc_column][vc_column css=".vc_custom_1544070883184{margin-top: 50px !important;padding-right: 15px !important;padding-left: 15px !important;}" offset="vc_col-lg-3 vc_col-md-12 vc_hidden-md vc_hidden-sm vc_hidden-xs" el_class="sidebar"][vc_widget_sidebar sidebar_id="archive"][/vc_column][/vc_row]'
            ),
            'templates-about-me' => array(
                'name' 			=> esc_html__( 'About Me', 'ganesa' ),
                'weight' 		=> 0,
                'image_path' 	=> get_template_directory_uri() . '/inc/backend/assets/images/home/home3.jpg',
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1544206345170{background-image: url(http://localhost/wp/wp-ganesa/wp-content/uploads/2018/12/bg-about.jpg?id=2443) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="bg-fixed"][vc_column][vc_empty_space height="150px" el_class="hidden-sm hidden-xs"][vc_column_text css=".vc_custom_1544200179109{margin-top: 100px !important;margin-bottom: 100px !important;}"]
<h2 class="title-page" style="text-align: center; color: white;">About Me</h2>
[/vc_column_text][vc_empty_space height="150px" el_class="hidden-sm hidden-xs"][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space height="60px" el_class="hidden-sm hidden-xs"][na_about_me image_box="2461" title_box="Im Kenna Braner" image_f="2394" content_box="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed sed lacinia elit. Quisque euismod, dui vitae consequat pharetra, nunc purus ultrices turpis, nec tristique enim ante sit amet ex. Nullam nec sem sit amet justo vestibulum dignissim id nec nisl. " items="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-pinterest%22%2C%22link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22link%22%3A%22%23%22%7D%5D" image_items="%5B%7B%22image_gallery%22%3A%221887%22%7D%2C%7B%22image_gallery%22%3A%221885%22%7D%2C%7B%22image_gallery%22%3A%221884%22%7D%2C%7B%22image_gallery%22%3A%222006%22%7D%2C%7B%22image_gallery%22%3A%221999%22%7D%2C%7B%22image_gallery%22%3A%221987%22%7D%5D"][/vc_column][/vc_row]'
            ),
            'templates-contact-us' => array(
                'name' 			=> esc_html__( 'Templates Contact Us', 'ganesa' ),
                'weight' 		=> 0,
                'custom_class'	=> '',
                'content' 		=> '[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1544195873491{background-image: url(http://localhost/wp/wp-ganesa/wp-content/uploads/2018/12/bg-contact.jpg?id=2428) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="bg-fixed"][vc_column][vc_empty_space height="150px" el_class="hidden-sm hidden-xs"][vc_column_text css=".vc_custom_1544195751285{margin-top: 100px !important;margin-bottom: 100px !important;}"]
<h2 class="title-page" style="text-align: center; color: white;">Contact Us</h2>
[/vc_column_text][vc_empty_space height="150px" el_class="hidden-sm hidden-xs"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1544199236333{margin-top: 40px !important;}"][vc_column el_class="box-contact" offset="vc_col-lg-6 vc_col-md-12"][vc_empty_space height="40px" el_class="hidden-sm hidden-xs"][contact-form-7 id="76" title="Get in touch with us "][/vc_column][vc_column css=".vc_custom_1544027246793{padding-left: 100px !important;}" offset="vc_col-lg-6 vc_col-md-12"][vc_empty_space height="40px" el_class="hidden-sm hidden-xs"][vc_column_text el_class="nano-address"]
<div class="box-text">
<h3 class="text-title clearfix">Contact Details</h3>
<div class="text-des">Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Cras mattis consectetur amet fermentum. Sed posuere consectetur est at lobortis.</div>
<i class="fa fa-map-marker"></i> 198 West 21th Street, Suite 721 New York, NY 10010

<i class="fa fa-phone"></i> Phone: +95 (0) 123 456 789

<i class="fa fa-envelope-o"></i> <a href="mailto:nanoagency@gmail.com">nanoagency.co@gmail.com</a>

</div>
[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1544239535414{margin-top: 30px !important;}"][vc_column][vc_empty_space height="40px" el_class="hidden-sm hidden-xs"][vc_gmaps link="#E-8_JTNDaWZyYW1lJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZ3d3cuZ29vZ2xlLmNvbSUyRm1hcHMlMkZlbWJlZCUzRnBiJTNEJTIxMW0xOCUyMTFtMTIlMjExbTMlMjExZDYzMDQuODI5OTg2MTMxMjcxJTIxMmQtMTIyLjQ3NDY5NjgwMzMwOTIlMjEzZDM3LjgwMzc0NzUyMTYwNDQzJTIxMm0zJTIxMWYwJTIxMmYwJTIxM2YwJTIxM20yJTIxMWkxMDI0JTIxMmk3NjglMjE0ZjEzLjElMjEzbTMlMjExbTIlMjExczB4ODA4NTg2ZTYzMDI2MTVhMSUyNTNBMHg4NmJkMTMwMjUxNzU3YzAwJTIxMnNTdG9yZXklMkJBdmUlMjUyQyUyQlNhbiUyQkZyYW5jaXNjbyUyNTJDJTJCQ0ElMkI5NDEyOSUyMTVlMCUyMTNtMiUyMTFzZW4lMjEyc3VzJTIxNHYxNDM1ODI2NDMyMDUxJTIyJTIwJTIwYWxsb3dmdWxsc2NyZWVuJTNEJTIyJTIyJTIwd2lkdGglM0QlMjIxMTcwJTIyJTIwaGVpZ2h0JTNEJTIyNjAwJTIyJTIwZnJhbWVib3JkZXIlM0QlMjIwJTIyJTNFJTNDJTJGaWZyYW1lJTNF" el_class="contact-maps"][/vc_column][/vc_row]',
            ),

        );


        foreach ( array_reverse( $new_templates ) as $template ) {
            array_unshift( $default_templates, $template );
        }

        return $default_templates;
    }
    add_filter( 'vc_load_default_templates', 'ganesa_vc_templates' );
}

