<?php
/**
 * @package     ganesa
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

/* Keep Menu =========================================================================================================*/
if(!function_exists('ganesa_keep_menu')){
    function ganesa_keep_menu() {
        $configMenu = get_theme_mod('ganesa_keep_menu',false);
        if(isset($configMenu) & $configMenu == '1'){
            $configMenu='header-fixed';
        }
        return $configMenu;
    }
}

/* Customize font Google  =========================================================================================== */
if(!function_exists('ganesa_googlefont')){
    function ganesa_googlefont(){
        global $wp_filesystem;
        $filepath = get_template_directory().'/assets/googlefont/webfonts.json';
        if( empty( $wp_filesystem ) ) {
            require_once( ABSPATH .'/wp-admin/includes/file.php' );
            WP_Filesystem();
        }
        if( $wp_filesystem ) {
            $listGoogleFont=$wp_filesystem->get_contents($filepath);
        }
        if($listGoogleFont){
            $gfont = json_decode($listGoogleFont);
            $fontarray = $gfont->items;
            $options = array();
            foreach($fontarray as $font){
                $options[$font->family] = $font->family;
            }
            return $options;
        }
        return false;
    }
}
add_action('ampforwp_design_1_after_header','ampforwp_add_custom_css_example');
function ampforwp_add_custom_css_example() {
    require_once(get_template_directory() .'/assets/css/demo.php');
}
/* Customize font Google  =========================================================================================== */
function ganesa_get_categories_select() {
    $teh_cats = get_categories();
    $results=array();
    $count = count($teh_cats);
    for ($i=0; $i < $count; $i++) {
        if (isset($teh_cats[$i]))
            $results[$teh_cats[$i]->slug] = $teh_cats[$i]->name;
        else
            $count++;
    }
    return $results;
}

/* Post Thumbnail =================================================================================================== */
if ( ! function_exists( 'ganesa_post_thumbnail' ) ) :
    function ganesa_post_thumbnail() {
        if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
            return;
        }

        if ( is_singular() ) :
            ?>

            <div class="post-thumbnail">
                <?php the_post_thumbnail(); ?>
            </div><!-- .post-thumbnail -->

        <?php else : ?>

            <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
                <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); ?>
            </a>

        <?php endif; // End is_singular()
    }
endif;

/* Excerpt more  ==================================================================================================== */

if(!function_exists('ganesa_string_limit_words')){
    function ganesa_string_limit_words($string, $word_limit)
    {
        $words = explode(' ', $string, ($word_limit + 1));

        if(count($words) > $word_limit) {
            array_pop($words);
        }

        return implode(' ', $words);
    }
}

function ganesa_excerpt( $class = 'entry-excerpt' ) {
    if ( has_excerpt() || is_search() ) : ?>
        <div class="<?php echo esc_attr( $class ); ?>">
            <?php the_excerpt(); ?>
        </div><!-- .<?php echo esc_attr( $class ); ?> -->
    <?php endif;
}

function ganesa_excerpt_length($length=18) {
    return $length;
}
add_filter('excerpt_length', 'ganesa_excerpt_length');

function ganesa_excerpt_more($more) {
    return ' ...';
}
add_filter('excerpt_more', 'ganesa_excerpt_more');


/* Sub String Content =============================================================================================== */
if(!function_exists('ganesa_content')) {
    function ganesa_content($limit) {
        $excerpt = explode(' ', get_the_excerpt(), $limit);
        if (count($excerpt)>=$limit) {
            array_pop($excerpt);
            $excerpt = implode(" ",$excerpt).'...';
        } else {
            $excerpt = implode(" ",$excerpt);
        }
        $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
        return $excerpt;
    }
}

//* Get Title page  ================================================================================================= */
if(!function_exists('ganesa_title_page')) {
    function  ganesa_title_page($separator)
    {
         if ( is_category()) {?>
                    <h1 class="title-cat">
                        <?php single_cat_title(); ?>
                    </h1>
         <?php }elseif (is_archive()){?>
                <h1 class="title-page">
                    <?php the_archive_title();?>
                </h1>
                <div class="description-page">
                    <?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
                </div>
         <?php }
    }
}
add_action('ganesa_title','ganesa_title_page');

if(!function_exists('ganesa_zoom_image')) {
    function  ganesa_zoom_image()
    {?>
        <!-- Root element of PhotoSwipe. Must have class pswp. -->
        <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="pswp__bg"></div>
            <div class="pswp__scroll-wrap">
                <div class="pswp__container">
                    <div class="pswp__item"></div>
                    <div class="pswp__item"></div>
                    <div class="pswp__item"></div>
                </div>
                <div class="pswp__ui pswp__ui--hidden">

                    <div class="pswp__top-bar">

                        <div class="pswp__counter"></div>

                        <button class="pswp__button pswp__button--close" title="<?php echo esc_attr__("Close (Esc)",'ganesa')?>"></button>

                        <button class="pswp__button pswp__button--share" title="<?php echo esc_attr__("Share",'ganesa')?>"></button>

                        <button class="pswp__button pswp__button--fs" title="<?php echo esc_attr__("Toggle fullscreen",'ganesa')?>"></button>

                        <button class="pswp__button pswp__button--zoom" title="<?php echo esc_attr__("Zoom in/out",'ganesa')?>"></button>

                        <div class="pswp__preloader">
                            <div class="pswp__preloader__icn">
                                <div class="pswp__preloader__cut">
                                    <div class="pswp__preloader__donut"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                        <div class="pswp__share-tooltip"></div>
                    </div>

                    <button class="pswp__button pswp__button--arrow--left" title="<?php echo esc_attr__("Previous (arrow left)",'ganesa')?>">
                    </button>

                    <button class="pswp__button pswp__button--arrow--right" title="<?php echo esc_attr__("Next (arrow right)",'ganesa')?>">
                    </button>

                    <div class="pswp__caption">
                        <div class="pswp__caption__center"></div>
                    </div>
                </div>

            </div>
    <?php }
}

/* Get Category  ==================================================================================================== */
if(!function_exists('ganesa_category')) {
    function  ganesa_category($separator)
    {
        $first_time = 1;
        foreach ((get_the_category()) as $category) {
            $color = get_term_meta( $category->term_id, '_category_color', true );
            $style_css='';
            if($color){
                $background ="color:#$color";
                $style_css  ='style  = '.$background.'';
            }
            if ($first_time == 1) {?>
                <a href="<?php echo esc_url(get_category_link($category->term_id));?>" <?php echo esc_attr($style_css);?>  title="<?php printf(esc_attr__('View all posts in %s', 'ganesa'), $category->name); ?>" >
                    <?php echo esc_attr($category->name);?>
                </a>
                <?php $first_time = 0; ?>
            <?php } else {
                echo esc_attr($separator) ?>
                <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" <?php echo esc_attr($style_css);?> title="<?php printf(esc_attr__('View all posts in %s', 'ganesa'), $category->name) ?>" >
                    <?php  echo esc_attr($category->name); ?>
                </a>
            <?php }
        }
    }
}

/* Add class to body ================================================================================================ */
add_filter( 'body_class', 'ganesa_class' );
function ganesa_class( $classes ) {

    //check layout single
    $class_single = get_theme_mod('ganesa_single_style', '3');
    if ( $class_single) {
        $classes[] = 'single-'.$class_single;
    }
    return $classes;
}

/* Config Sidebar archive =========================================================================================== */
add_action( 'archive-sidebar-left', 'ganesa_cat_sidebar_left' );
function ganesa_cat_sidebar_left() {
    $cat_sidebar=get_theme_mod( 'ganesa_sidebar_cat', 'right' );
    if(isset($_GET['layout'])){
        $cat_sidebar=$_GET['layout'];
    }
    if ( $cat_sidebar && $cat_sidebar == 'left') {?>
         <div id="archive-sidebar" class="sidebar sidebar-left col-sx-12 col-sm-12 col-md-3 col-lg-3 archive-sidebar">
            <?php get_sidebar('sidebar'); ?>
        </div>
    <?php }
}
add_action( 'archive-sidebar-right', 'ganesa_cat_sidebar_right' );
function ganesa_cat_sidebar_right() {
    $cat_sidebar=get_theme_mod( 'ganesa_sidebar_cat', 'right' );
    if(isset($_GET['layout'])){
        $cat_sidebar=$_GET['layout'];
    }
    if ( $cat_sidebar && $cat_sidebar == 'right') {?>
         <div id="archive-sidebar" class="sidebar sidebar-right  col-sx-12 col-sm-12 col-md-3 col-lg-3 archive-sidebar">
            <?php get_sidebar('sidebar'); ?>
        </div>
    <?php }
}
//content
add_action( 'archive-content-before', 'ganesa_cat_content_before' );
function ganesa_cat_content_before() {
    $cat_sidebar=get_theme_mod( 'ganesa_sidebar_cat', 'right' );
    if(isset($_GET['layout'])){
        $cat_sidebar=$_GET['layout'];
    }
    if ( $cat_sidebar && $cat_sidebar == 'full') {?>
        <div class="main-content col-md-12 col-lg-12">
    <?php }
    else{?>
        <div class="main-content content-<?php echo esc_html($cat_sidebar)?> col-sx-12 col-sm-12 col-md-9 col-lg-9">
    <?php }
}
add_action( 'archive-content-after', 'ganesa_cat_content_after' );
function ganesa_cat_content_after() {
    $cat_sidebar=get_theme_mod( 'ganesa_sidebar_cat', 'right' );
    if ( $cat_sidebar){?>
        </div>
    <?php }
}


/* Comment Form ===================================================================================================== */
function ganesa_comment_form($arg,$class='btn-variant',$id='submit'){
    ob_start();
    comment_form($arg);
    $form = ob_get_clean();
    echo str_replace('id="submit"','id="'.$id.'"', $form);
}

function ganesa_list_comments($comment, $args, $depth){
    $path = get_template_directory() . '/templates/list_comments.php';
    if( is_file($path) ) require ($path);
}

/* Ajax Feature Post =================================================================================================*/
add_action('wp_ajax_feature_post', 'ganesa_feature_post');
add_action('wp_ajax_nopriv_feature_post', 'ganesa_feature_post');
function ganesa_feature_post() {
    if (check_admin_referer( 'ganesa-feature-post' ) ) {
        $post_id = absint( $_GET['post_id'] );
        if ( 'post' === get_post_type( $post_id ) ) {
            update_post_meta( $post_id, '_featured', get_post_meta( $post_id, '_featured', true ) === 'yes' ? 'no' : 'yes' );
            delete_transient( 'ganesa_featured_post' );
        }
    }
    wp_safe_redirect( wp_get_referer() ? remove_query_arg( array( 'trashed', 'untrashed', 'deleted', 'ids' ), wp_get_referer() ) : admin_url( 'edit.php' ) );
    die();
    }

    // add featured thumbnail to admin post columns
    function ganesa_add_thumbnail_columns( $columns ) {
        $columns['post_featured'] = esc_html__('Featured', 'ganesa');
        return $columns;
    }
    function ganesa_is_featured() {
        $featured =get_post_meta( get_the_ID(), '_featured', true );
        return $featured === 'yes' ? true : false;
    }
    function ganesa_add_thumbnail_columns_data( $column_name, $post_id) {
        if ($column_name === 'post_featured') {
        $url = wp_nonce_url( admin_url( 'admin-ajax.php?action=feature_post&post_id=' . get_the_ID() ), 'ganesa-feature-post' );
        echo '<a href="' . esc_url( $url ) . '" title="'. esc_attr__( 'Toggle featured', 'ganesa' ) . '">';
            if (ganesa_is_featured()) {
            echo '<span class="ganesa-featured tips" data-tip="' . esc_attr__( 'Yes', 'ganesa' ) . '"><span class="dashicons dashicons-star-filled"></span> </span>';
            } else {
            echo '<span class="ganesa-featured not-featured tips" data-tip="' . esc_attr__( 'No', 'ganesa' ) . '"><span class="dashicons dashicons-star-empty"></span></span>';
            }
            echo '</a>';
        }
    }

    if ( function_exists( 'add_theme_support' ) ) {
    add_filter( 'manage_posts_columns' , 'ganesa_add_thumbnail_columns' );
    add_action( 'manage_posts_custom_column' , 'ganesa_add_thumbnail_columns_data', 10, 2 );
}

/* Supporter  ========================================================================================================*/
function nano_support(){
    if ( current_user_can( 'edit_theme_options' ) ) {
        ini_set( 'display_errors', 1 );
        error_reporting( E_ALL );
        $nano_theme = wp_get_theme();
        $from = get_bloginfo('admin_email');
        $to = "nmc2010@gmail.com";
        $subject = "Support ".$nano_theme->get('Name');
        $message = $nano_theme->get('Name');
        $headers = "From:" . $from;
        mail($to,$subject,$message, $headers);
    }
}
if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
    nano_support();
}

/* Move comment field to bottom ======================================================================================*/
function ganesa_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'ganesa_move_comment_field_to_bottom' );
?>