<?php
/**
 * @package     ganesa
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

/*  Setup Theme ===================================================================================================== */
add_action( 'after_setup_theme', 'ganesa_theme_setup' );
if ( ! function_exists( 'ganesa_theme_setup' ) ) :
    function ganesa_theme_setup() {
        load_theme_textdomain( 'ganesa', get_template_directory() . '/languages' );

        //  Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        //  Let WordPress manage the document title.
        add_theme_support( 'title-tag' );

        //  Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );

        //Enable support for Post Formats.
        add_theme_support( 'html5', array(
            'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
        ) );

        add_theme_support( 'post-formats', array(
            'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
        ) );

        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

        add_theme_support( 'custom-header' );

        add_theme_support( 'custom-background' );

        add_theme_support( "title-tag" );

        add_theme_support( 'wp-block-styles' );

        add_theme_support( 'align-wide' );

        add_theme_support( 'editor-styles' );

        add_editor_style( array( 'assets/css/editor-style.css', ganesa_font_url() ) );

        add_theme_support( 'responsive-embeds' );


        add_theme_support( 'editor-color-palette', array(
            array(
                'name' => __( 'strong magenta', 'ganesa' ),
                'slug' => 'strong-magenta',
                'color' => '#a156b4',
            ),
            array(
                'name' => __( 'light grayish magenta', 'ganesa' ),
                'slug' => 'light-grayish-magenta',
                'color' => '#d0a5db',
            ),
            array(
                'name' => __( 'very light gray', 'ganesa' ),
                'slug' => 'very-light-gray',
                'color' => '#eee',
            ),
            array(
                'name' => __( 'very dark gray', 'ganesa' ),
                'slug' => 'very-dark-gray',
                'color' => '#444',
            ),
        ) );
    }
endif;

/* Thumbnail Sizes ================================================================================================== */
set_post_thumbnail_size( 220, 150, true);

add_image_size( 'ganesa-single', 1400 ,600, true);

add_image_size( 'ganesa-blog-list', 720 ,427, true);

add_image_size( 'ganesa-blog-video', 1000,489, true);

add_image_size( 'ganesa-blog-grid', 640 ,400, true);

add_image_size( 'ganesa-blog-grid-vertical',530,698, true);

add_image_size( 'ganesa-blog-vertical', 467 ,550, true);

add_image_size( 'ganesa-sidebar', 124 ,100, true);

/* Setup Font ======================================================================================================= */
function ganesa_font_url() {
    $fonts_url = '';
    $roboto     = _x( 'on', 'Josefin Sans font: on or off', 'ganesa' );
    if ( 'off' !== $roboto ) {
        $font_families = array();
        if ( 'off' !== $roboto ) {
            $font_families[] = 'Josefin Sans:300,400,400i,600';
        }
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}


/* Load Front-end scripts  ========================================================================================== */
add_action( 'wp_enqueue_scripts', 'ganesa_theme_scripts');
function ganesa_theme_scripts() {

    // Add  fonts, used in the main stylesheet.
    wp_enqueue_style( 'ganesa-fonts', ganesa_font_url(), array(), null );
    //style plugins
    wp_enqueue_style('bootstrap',get_template_directory_uri().'/assets/css/bootstrap.min.css', array(), '3.0.2 ');
    wp_enqueue_style('awesome-font',get_template_directory_uri().'/assets/css/font-awesome.min.css', array(), '4.6.3');
    wp_enqueue_style('jquery-ui',get_template_directory_uri().'/assets/css/jquery-ui.min.css', array(), '1.11.4');
    wp_enqueue_style('ionicons-font',get_template_directory_uri().'/assets/css/plugins/ionicons.min.css', array(),'2.0.0');
    wp_enqueue_style('photoswipe',get_template_directory_uri().'/assets/css/photoswipe.css', array(), null);
    wp_enqueue_style('default-skin',get_template_directory_uri().'/assets/css/default-skin/default-skin.css', array(), null);
    //style MAIN THEME
    wp_enqueue_style( 'ganesa-main', get_template_directory_uri(). '/style.css', array(), null );
    //style skin
    wp_enqueue_style('ganesa-css', get_template_directory_uri().'/assets/css/style-default.min.css' );

    //register all plugins
    wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/plugins/bootstrap.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'html5', get_template_directory_uri().'/assets/js/plugins/html5.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'slicknav', get_template_directory_uri().'/assets/js/plugins/jquery.slicknav.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'skip-link-focus', get_template_directory_uri().'/assets/js/plugins/skip-link-focus-fix.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'sticky-sidebar', get_template_directory_uri().'/assets/js/plugins/jquery.sticky-sidebar.js', array(), '2.2.0', true );
    wp_enqueue_script( 'slick', get_template_directory_uri().'/assets/js/plugins/slick.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'isotope', get_template_directory_uri().'/assets/js/plugins/isotope.pkgd.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'lazy', get_template_directory_uri().'/assets/js/plugins/jquery.lazy.js', array(), '2.2.0', true );
    wp_register_script('tweets-widgets', get_template_directory_uri().'/assets/js/plugins/tweets-widgets.min.js','jquery', '2.3.0', true);
    wp_enqueue_script('jquery-masonry');

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    if ( is_singular()) {
        wp_enqueue_script( 'photoswipe', get_template_directory_uri().'/assets/js/plugins/photoswipe.min.js', array(), null, true );
        wp_enqueue_script( 'photoswipe-ui-default', get_template_directory_uri().'/assets/js/plugins/photoswipe-ui-default.min.js', array(), null, true );
    }
    if ( is_singular() && wp_attachment_is_image() ) {
        wp_enqueue_script( 'ganesa-theme-keyboard-image-navigation', get_template_directory_uri() . '/assets/js/keyboard-image-navigation.min.js', array( 'jquery' ), '20141010' );
    }

    //jquery MAIN THEME
    wp_enqueue_script('ganesa-init', get_template_directory_uri() . '/assets/js/dev/ganesa-init.js', array('jquery'),null, true);
    wp_enqueue_script('ganesa', get_template_directory_uri() . '/assets/js/dev/ganesa.js', array('jquery'),null, true);

}

/* Load Back-end SCRIPTS============================================================================================= */
function ganesa_js_enqueue()
{
    wp_enqueue_media();
    wp_enqueue_style('thickbox');
    wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
    // moved the js to an external file, you may want to change the path
    wp_enqueue_script('information-js',get_template_directory_uri(). '/assets/js/widget.min.js', 'jquery', '1.0', true);
}
add_action('admin_enqueue_scripts', 'ganesa_js_enqueue');

/* Register the required plugins    ================================================================================= */
add_action( 'tgmpa_register', 'ganesa_register_required_plugins' );
function ganesa_register_required_plugins() {

    $plugins = array(
        // This is an example of how to include a plugin pre-packaged with a theme.
        //Nano Core Plugin
        array(
            'name'      => esc_html__( 'Nano Core Plugin', 'ganesa' ),
            'slug'      => 'theme-core',
            'source'    => get_template_directory() . '/inc/theme-plugins/theme-core.zip',
            'required'  => true,
            'version'   => '1.0.2',
            'force_activation' => false,
            'force_deactivation' => false,
        ),
        //Contact form 7
        array(
            'name'      => esc_html__('Contact Form 7', 'ganesa' ),
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),
        //WPBakery Visual Composer
        array(
            'name'      =>  esc_html__('WPBakery Visual Compose', 'ganesa' ),
            'slug'      => 'js_composer',
            'source'    => get_template_directory() . '/inc/theme-plugins/js_composer.zip',
            'required'  => true,
            'version'   => '5.7',
        ),
        //MailChimp for WordPress
        array(
            'name'      =>  esc_html__('MailChimp for WordPress ', 'ganesa' ),
            'slug'      => 'mailchimp-for-wp',
            'required'  => false,
        ),
        //Loco Translate
        array(
            'name'      =>  esc_html__('Loco Translate', 'ganesa' ),
            'slug'      => 'loco-translate',
            'required'  => false,
        ),
        //Classic Editor
        array(
            'name'      =>  esc_html__('Classic Editor', 'ganesa' ),
            'slug'      => 'classic-editor',
            'required'  => false,
        ),

    );

    $config = array(
        'id'           => 'ganesa',                   // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                       // Default absolute path to pre-packaged plugins.
        'has_notices'  => true,
        'menu'         => 'tgmpa-install-plugins',  // Menu slug.
        'dismiss_msg'  => '',                       // If 'dismissable' is false, this message will be output at top of nag.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'is_automatic' => true,                     // Automatically activate plugins after installation or not.
        'message'      => '',                       // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );

}

/* Register Navigation ============================================================================================== */
register_nav_menus( array(
    'primary_navigation'    => esc_html__( 'Primary Navigation', 'ganesa' ),
) );

/* Register Sidebar ================================================================================================= */
function ganesa_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Archive', 'ganesa' ),
        'id'            => 'archive',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar of archive page', 'ganesa' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar 1', 'ganesa' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Custom the sidebar for your homepage.', 'ganesa' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Single', 'ganesa' ),
        'id'            => 'single',
        'description'   => esc_html__( 'Add widgets here to appear in your sidebar of Single page', 'ganesa' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer Top','ganesa'),
        'id'   => 'footer-top',
        'description'   => esc_html__( 'Add widgets here to appear in Footer Top sidebar', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 1','ganesa'),
        'id'   => 'footer-1',
        'description'   => esc_html__( 'Add the widget here to appear in the first Footer column.', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 2','ganesa'),
        'id'   => 'footer-2',
        'description'   => esc_html__( 'Add the widget here to appear in the second Footer column.', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 3','ganesa'),
        'id'   => 'footer-3',
        'description'   => esc_html__( 'Add the widget here to appear in the 3rd Footer column.', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer 4','ganesa'),
        'id'   => 'footer-4',
        'description'   => esc_html__( 'Add the widget here to appear in the 4rd Footer column.', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Custom Copy Right','ganesa'),
        'id'   => 'copy-right',
        'description'   => esc_html__( 'Add the widget here to appear in left right of Copy Right Footer', 'ganesa' ),
        'before_widget' => '<div id="%1$s" class="widget first %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));
}
add_action( 'widgets_init', 'ganesa_widgets_init' );