<?php
/**
 * @package     NA Core
 * @version     0.1
 * @author      Nanoganesa
 * @link        http://nanoganesa.co
 * @copyright   Copyright (c) 2015 Nanoganesa
 * @license     GPL v2
 */
if (!class_exists('ganesa_Customize')) {
    class ganesa_Customize
    {
        public $customizers = array();

        public $panels = array();

        public function init()
        {
            $this->customizer();
            add_action('customize_controls_enqueue_scripts', array($this, 'ganesa_customizer_script'));
            add_action('customize_register', array($this, 'ganesa_register_theme_customizer'));
            add_action('customize_register', array($this, 'remove_default_customize_section'), 20);
        }

        public static function &getInstance()
        {
            static $instance;
            if (!isset($instance)) {
                $instance = new ganesa_Customize();
            }
            return $instance;
        }

        protected function customizer()
        {
            $this->panels = array(

                'site_panel' => array(
                    'title'             => esc_html__('Style Setting','ganesa'),
                    'description'       => esc_html__('Style Setting >','ganesa'),
                    'priority'          =>  101,
                ),
                'single_panel' => array(
                    'title'             => esc_html__('Blog Single','ganesa'),
                    'description'       => esc_html__('Blog Single >','ganesa'),
                    'priority'          =>  104,
                ),
                'sidebar_panel' => array(
                    'title'             => esc_html__('Sidebar','ganesa'),
                    'description'       => esc_html__('Sidebar Setting','ganesa'),
                    'priority'          => 105,
                ),
                'ganesa_option_panel' => array(
                    'title'             => esc_html__('Option','ganesa'),
                    'description'       => '',
                    'priority'          => 106,
                ),

            );

            $this->customizers = array(
                'title_tagline' => array(
                    'title' => esc_html__('Site Identity', 'ganesa'),
                    'priority'  =>  1,
                    'settings' => array(
                        'ganesa_logo' => array(
                            'class' => 'image',
                            'label' => esc_html__('Logo', 'ganesa'),
                            'description' => esc_html__('Upload Logo Image', 'ganesa'),
                            'priority' => 12
                        ),
                        'ganesa_logo_theme' => array(
                            'type'          => 'checkbox',
                            'label'         => esc_html__('Logo Theme', 'ganesa'),
                            'priority'      => 99,
                            'params'        => array(
                                'default'   => false,
                            ),
                        ),
                    )
                ),
//2.General ============================================================================================================
                'ganesa_general' => array(
                    'title' => esc_html__('General', 'ganesa'),
                    'description' => '',
                    'priority' => 2,
                    'settings' => array(

                        'ganesa_bg_body' => array(
                            'label'         => esc_html__('Background - Body', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 2,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'ganesa_primary_body' => array(
                            'label'         => esc_html__('Primary - Color', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 1,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//3.Header =============================================================================================================
                'ganesa_header' => array(
                    'title' => esc_html__('Header', 'ganesa'),
                    'description' => '',
                    'priority' => 3,
                    'settings' => array(
                        'ganesa_header_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Header', 'ganesa'),
                            'priority' => 2,
                        ),
                        'ganesa_header' => array(
                            'type' => 'select',
                            'label' => esc_html__('Choose Header Layout', 'ganesa'),
                            'description' => '',
                            'priority' => 1,
                            'choices' => array(
                                'simple'    => esc_html__('Header Default', 'ganesa'),
                                'full'      => esc_html__('Header Full Width', 'ganesa'),
                                'center'    => esc_html__('Header Center', 'ganesa')
                            ),
                            'params' => array(
                                'default' => 'simple',
                            ),

                        ),
                        'ganesa_keep_menu' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Keep Menu','ganesa'),
                            'priority' => 6,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_bg_header' => array(
                            'label'         => esc_html__('Background - Header', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 7,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),

                        'ganesa_color_menu' => array(
                            'label'         => esc_html__('Color - Text', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 8,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//4.Footer =============================================================================================================
                'ganesa_new_section_footer' => array(
                    'title' => esc_html__('Footer', 'ganesa'),
                    'description' => '',
                    'priority' => 4,
                    'settings' => array(
                        'ganesa_footer' => array(
                            'type' => 'select',
                            'label' => esc_html__('Choose Footer Style', 'ganesa'),
                            'description' => '',
                            'priority' => -1,
                            'choices' => array(
                                '1'     => esc_html__('Footer 1', 'ganesa'),
                                'hidden' => esc_html__('Hidden Footer', 'ganesa')
                            ),
                            'params' => array(
                                'default' => '1',
                            ),
                        ),


                        'ganesa_enable_footer' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Footer', 'ganesa'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'ganesa_enable_copyright' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Copyright', 'ganesa'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'ganesa_copyright_text' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('Footer Copyright Text', 'ganesa'),
                            'description' => '',
                            'priority' => 0,
                        ),

                        'ganesa_bg_footer' => array(
                            'label'         => esc_html__('Background - Footer', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 5,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                        'ganesa_color_footer' => array(
                            'label'         => esc_html__('Color - Text ', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                    )
                ),

//5.Categories Blog ====================================================================================================
                'ganesa_blog' => array(
                    'title' => esc_html__('Blogs Categories', 'ganesa'),
                    'description' => '',
                    'priority' => 103,
                    'settings' => array(
                        'ganesa_post_title_heading' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Title Category ','ganesa'),
                            'priority' => 6,
                            'params' => array(
                                'default' => true,
                            ),
                        ),

                        'ganesa_post_cat_layout' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Category layout', 'ganesa'),
                            'priority' =>8,
                        ),
                        'ganesa_layout_cat_content' => array(
                            'class'         => 'layout',
                            'priority'      =>9,
                            'choices'       => array(
                                'trans'        => get_template_directory_uri().'/assets/images/box-tran.jpg',
                                'grid'        => get_template_directory_uri().'/assets/images/box-taxonomy.jpg',
                                'grid-des'        => get_template_directory_uri().'/assets/images/box-slax.jpg',
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'list',
                            ),
                        ),
                        //post article content
                        'ganesa_post_cat_article' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post content', 'ganesa'),
                            'priority' =>11,
                        ),
                        'ganesa_number_content_post' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of words in the description content', 'ganesa'),
                            'description' => '',
                            'priority' =>13,
                            'choices' => array(
                                'max' => 50,
                                'min' => 20,
                                'step' => 5
                            ),
                            'params'      => array(
                                'default' =>25
                            ),
                        ),

                        //post meta
                        'ganesa_cat_meta' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post meta', 'ganesa'),
                            'priority' =>13,
                        ),
                        'ganesa_post_meta_author' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author ','ganesa'),
                            'priority' => 15,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_post_meta_date' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Date ','ganesa'),
                            'priority' => 16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'ganesa_post_meta_share' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share ','ganesa'),
                            'priority' => 19,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
//6.Single blog ========================================================================================================
                'ganesa_single_sidebar' => array(
                    'title' => esc_html__('Single Layout', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        'ganesa_single_style' => array(
                            'class'         => 'layout',
                            'label'         => esc_html__('Single style', 'ganesa'),
                            'priority'      =>1,
                            'choices'       => array(
                                '1'         => get_template_directory_uri().'/assets/images/single/single-1.jpg',
                                '2'        => get_template_directory_uri().'/assets/images/single/single-2.jpg',
                                '3'         => get_template_directory_uri().'/assets/images/single/single-3.jpg',
                            ),
                            'params' => array(
                                'default' => '3',
                            ),
                        ),
                        'ganesa_siderbar_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'ganesa'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Single .', 'ganesa' ),
                            'priority' => 2,
                        ),

                        'ganesa_single_own' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Use Single sidebar','ganesa'),
                            'priority' => 3,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_siderbar_single2_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'ganesa'),
                            'description' => esc_html__( 'When you active use Single sidebar , Please goto Appearance > Widgets > drop drag widget to the sidebar Single  not sidebar Archive.', 'ganesa' ),
                            'priority' => 4,
                        ),
                    ),
                ),

                //Share
                'ganesa_single_layout' => array(
                    'title' => esc_html__('Social Share', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //share
                        'ganesa_share_position' => array(
                            'type' => 'select',
                            'label' => __('Position Share', 'ganesa'),
                            'description' => '',
                            'priority' => 10,
                            'choices' => array(
                                'fixed' => 'Fixed left',
                                'bottom' => 'Bottom of the article',
                            ),
                            'params' => array(
                                'default' => 'fixed',
                            ),

                        ),
                        'ganesa_share_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'ganesa'),
                            'priority' =>18,
                        ),
                        'ganesa_share_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Facebook  ','ganesa'),
                            'priority' => 21,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_share_twitter' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Twitter  ','ganesa'),
                            'priority' => 22,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_share_google' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Google  ','ganesa'),
                            'priority' => 23,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_share_linkedin' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Linkedin  ','ganesa'),
                            'priority' => 24,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_share_pinterest' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Pinterest  ','ganesa'),
                            'priority' => 25,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
                //Comments
                'ganesa_single_comments' => array(
                    'title' => esc_html__('Comments', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //comments
                        'ganesa_comments' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Comments Box', 'ganesa'),
                            'priority' =>16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'ganesa_comments_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'ganesa'),
                            'priority' =>18,
                        ),
                        'ganesa_comments_single_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Enable Facebook Comments ','ganesa'),
                            'priority' => 29,
                            'params' => array(
                                'default' => false,
                            ),
                        ),

                        'ganesa_comments_single' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Your app id :', 'ganesa'),
                            'priority'      => 30,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'ganesa_comments_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'ganesa'),
                            'description' => esc_html__('If you want show notification on  your facebook , please input app id ...', 'ganesa' ),
                            'priority' => 31,
                        ),
                    ),
                ),

                'ganesa_single_meta' => array(
                    'title' => esc_html__('Meta', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //avatar-meta
                        'ganesa_avatar_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author', 'ganesa'),
                            'priority' =>1,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'ganesa_avatar_meta_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'ganesa'),
                            'description' => esc_html__( 'Show or Hidden  Author under the Title Post.If you want to disable/enable Author Box under Post , Please put or delete description in the User > Your profile > Biographical Info ', 'ganesa' ),
                            'priority' => 2,
                        ),
                        //avatar-meta
                        'ganesa_image_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Featured Image', 'ganesa'),
                            'priority' =>3,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                    ),
                ),
                'ganesa_single_related' => array(
                    'title' => esc_html__('Related Box', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //related_posts
                        'ganesa_related' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Related Posts', 'ganesa'),
                            'priority' =>17,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'ganesa_related_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'ganesa'),
                            'priority' =>18,
                        ),
                        'ganesa_related_number' => array(
                            'type' => 'select',
                            'label' => __('Number Post Show', 'ganesa'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '4',
                                '6' => '6',
                                '8' => '8',
                            ),
                            'params' => array(
                                'default' => '3',
                            ),

                        ),
                        'ganesa_related_rows' => array(
                            'type' => 'select',
                            'label' => __('Number Rows', 'ganesa'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ),
                            'params' => array(
                                'default' => '3',
                            ),

                        ),
                    ),
                ),

                'ganesa_single_readmore' => array(
                    'title' => esc_html__('Read More Box', 'ganesa'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //Read More
                        'ganesa_readmore_box' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Read More Box', 'ganesa'),
                            'priority' =>1,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_readmore_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'ganesa'),
                            'priority' =>2,
                        ),
                        'ganesa_readmore_cat' => array(
                            'class'          => 'multiple',
                            'label'         => esc_html__('Categories', 'ganesa'),
                            'choices'       => ganesa_get_categories_select(),
                            'priority'      => 3,
                            'params'        => array(
                                'default'       => esc_html__('', 'ganesa'),
                            ),

                        ),
                        'ganesa_readmore_layout' => array(
                            'class'         => 'layout',
                            'priority'      =>4,
                            'label'         => esc_html__('Layouts', 'ganesa'),
                            'choices'       => array(
                                'grid'        => get_template_directory_uri().'/assets/images/box-grid.jpg',
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'list',
                            ),
                        ),
                        'ganesa_readmore_show' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of posts displayed on a page', 'ganesa'),
                            'description' => '',
                            'priority' =>5,
                            'choices' => array(
                                'max' => 10,
                                'min' => 2,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>6
                            ),
                        ),
                        'ganesa_readmore_content' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Content Article', 'ganesa'),
                            'class' => 'toggle',
                            'priority' =>6,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_readmore_view_cats' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Category', 'ganesa'),
                            'class' => 'toggle',
                            'priority' =>7,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'ganesa_readmore_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Meta Article', 'ganesa'),
                            'priority' =>8,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'ganesa_readmore_btn' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Load More Button', 'ganesa'),
                            'priority' =>9,
                            'params' => array(
                                'default' => true,
                            ),
                        ),

                    ),
                ),
//Font   ===============================================================================================================
                'ganesa_new_section_font_size' => array(
                    'title' => esc_html__('Font', 'ganesa'),
                    'priority' => 8,
                    'settings' => array(
                        'ganesa_body_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Body - Font family', 'ganesa'),
                            'choices'       => ganesa_googlefont(),
                            'priority'      => 0,
                            'params'        => array(
                                'default'       => 'Josefin Sans',
                            ),

                        ),
                        'ganesa_body_font_size' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Body - Font size :', 'ganesa'),
                            'priority'      => 1,
                            'params'        => array(
                                'default'   => '22',
                            ),
                        ),
                        'ganesa_body_line_height' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Body - Line height :', 'ganesa'),
                            'priority'      => 2,
                            'params'        => array(
                                'default'   => '30',
                            ),
                        ),
                        'ganesa_body_font_weight' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Body - Font weight :', 'ganesa'),
                            'priority'      => 3,
                            'params'        => array(
                                'default'   => '300',
                            ),
                        ),
                        'ganesa_body_font_color' => array(
                            'label'         => esc_html__('Body - Color', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 4,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),

                        'ganesa_font_title_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Title', 'ganesa'),
                            'priority' =>8,
                        ),

                        'ganesa_title_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Title , Menu , Section Font', 'ganesa'),
                            'choices'       => ganesa_googlefont(),
                            'priority'      => 9,
                            'params'        => array(
                                'default'       => 'Josefin Sans',
                            ),
                        ),
                        'ganesa_section_font_size' => array(
                            'type'          => 'text',
                            'label' => esc_html__('Section - Font size ', 'ganesa'),
                            'description' => '',
                            'priority' =>10,
                            'params'        => array(
                                'default'   => '42',
                            ),
                        ),
                        'ganesa_title_font_size' => array(
                            'type'          => 'text',
                            'label' => esc_html__('Title Post - Font size ', 'ganesa'),
                            'description' => '',
                            'priority' =>11,
                            'params'        => array(
                                'default'   => '22',
                            ),
                        ),
                        'ganesa_title_font_color' => array(
                            'label'         => esc_html__('Title , Menu , Section - Color', 'ganesa'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 12,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),



                    )
                ),
//Style  ===============================================================================================================


            );
        }

        public function ganesa_customizer_script()
        {
            // Register
            wp_enqueue_style('ganesa-customize', get_template_directory_uri() . '/inc/customize/assets/css/customizer.css', array(),null);
            wp_enqueue_style('jquery-ui', get_template_directory_uri() . '/inc/customize/assets/css/jquery-ui.min.css', array(),null);
            wp_enqueue_script('ganesa-customize', get_template_directory_uri() . '/inc/customize/assets/js/customizer.js', array('jquery'), null, true);
        }

        public function add_customize($customizers) {
            $this->customizers = array_merge($this->customizers, $customizers);
        }


        public function ganesa_register_theme_customizer()
        {
            global $wp_customize;

            foreach ($this->customizers as $section => $section_params) {

                //add section
                $wp_customize->add_section($section, $section_params);
                if (isset($section_params['settings']) && count($section_params['settings']) > 0) {
                    foreach ($section_params['settings'] as $setting => $params) {

                        //add setting
                        $setting_params = array();
                        if (isset($params['params'])) {
                            $setting_params = $params['params'];
                            unset($params['params']);
                        }
                        $wp_customize->add_setting($setting, array_merge( array( 'sanitize_callback' => null ), $setting_params));
                        //Get class control
                        $class = 'WP_Customize_Control';
                        if (isset($params['class']) && !empty($params['class'])) {
                            $class = 'WP_Customize_' . ucfirst($params['class']) . '_Control';
                            unset($params['class']);
                        }

                        //add params section and settings
                        $params['section'] = $section;
                        $params['settings'] = $setting;

                        //add controll
                        $wp_customize->add_control(
                            new $class($wp_customize, $setting, $params)
                        );
                    }
                }
            }

            foreach($this->panels as $key => $panel){
                $wp_customize->add_panel($key, $panel);
            }

            return;
        }

        public function remove_default_customize_section()
        {
            global $wp_customize;
//            // Remove Sections
//            $wp_customize->remove_section('title_tagline');
            $wp_customize->remove_section('header_image');
            $wp_customize->remove_section('nav');
            $wp_customize->remove_section('static_front_page');
            $wp_customize->remove_section('colors');
            $wp_customize->remove_section('background_image');
        }
    }
}