<?php
//////////////////////////////////////////////////////////////////
// Customizer - Add CSS
//////////////////////////////////////////////////////////////////
/**
 * Enqueues front-end CSS for the page Font.
 *
 * @since nanoagency
 *
 * @see wp_add_inline_style()
 */
add_action( 'wp_enqueue_scripts', 'ganesa_font_google');
function ganesa_font_google()
{
    $font_family = get_theme_mod('ganesa_body_font_google', 'Josefin Sans');
    if ($font_family != 'Josefin Sans') {
        $query_args = array(
            'family' => urlencode($font_family),
            'subset' => urlencode('latin,latin-ext'),
        );
        $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
        $ganesa_google_font = esc_url_raw($fonts_url);
        wp_enqueue_style('ganesa-fonts-customize', $ganesa_google_font, array(), null);
    }
}
//body
function ganesa_body_font_family() {
    $default_font         = 'Josefin Sans';
    $font_family   = get_theme_mod('ganesa_body_font_google',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_family === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font family */
		body {
            font-family: %1$s;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_family ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_font_family', 11 );

function ganesa_body_font_size() {
    $default_font         = '22';
    $font_size   = get_theme_mod('ganesa_body_font_size',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_size === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font size */
		body ,.entry-content{
            font-size: %1$spx;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_size ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_font_size', 12 );

function ganesa_body_line_height() {
    $default_font         = '30';
    $font_line_height   = get_theme_mod('ganesa_body_line_height',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_line_height === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font line-height */
		body,.entry-content {
            line-height: %1$spx;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_line_height ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_line_height', 13 );

function ganesa_body_font_weight() {
    $default_font         = '300';
    $font_weight   = get_theme_mod('ganesa_body_font_weight',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_weight === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font weight */
		body ,.entry-content{
            font-weight: %1$spx;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_weight ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_font_weight', 14 );

function ganesa_body_font_color() {
    $default_font         = '';
    $font_color   = get_theme_mod('ganesa_body_font_color',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_color === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font color */
		body ,.entry-content{
            color: %1$s;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_color ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_font_color', 15 );

//title

function ganesa_family_title()
{
    $font_family_title = get_theme_mod('ganesa_title_font_google', 'Josefin Sans');
    if ($font_family_title != 'Josefin Sans') {
        $query_args = array(
            'family' => urlencode($font_family_title),
            'subset' => urlencode('latin,latin-ext'),
        );
        $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
        $ganesa_family_title = esc_url_raw($fonts_url);
        wp_enqueue_style('ganesa-fonts-customize', $ganesa_family_title, array(), null);
    }
}
add_action( 'wp_enqueue_scripts', 'ganesa_family_title');

function ganesa_title_font_google() {
    $default_font         = 'Josefin Sans';
    $font_family_title   = get_theme_mod('ganesa_title_font_google',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_family_title === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font title family */
		.title-left,.box-title,.title-page, .title-cat,#na-menu-primary ul > li > a ,.entry-title{
            font-family: %1$s;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_family_title ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_title_font_google', 16 );

function ganesa_section_font_size() {
    $default_font         = '42';
    $font_section_size   = get_theme_mod('ganesa_section_font_size',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_section_size === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font size */
		.box-featured .posts-featured,.box-recent .title-left,.title-left,.box-title,.title-page, .title-cat{
            font-size: %1$spx;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_section_size ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_section_font_size', 17 );

function ganesa_title_font_size() {
    $default_font         = '22';
    $font_title_size   = get_theme_mod('ganesa_title_font_size',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_title_size === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font size */
		.post-grid .entry-title,.post-list .entry-title,.post-tran .entry-title,.cats-grid-des .post-grid .entry-title{
            font-size: %1$spx;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_title_size ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_title_font_size', 17 );

function ganesa_title_font_color() {
    $default_font         = '';
    $font_title_color   = get_theme_mod('ganesa_title_font_color',$default_font);

    // Don't do anything if the current color is the default.
    if ( $font_title_color === $default_font ) {
        return;
    }

    $css = '
		/* Custom  Font color */
		.title-left,.box-title,.title-page, .title-cat,.entry-title > a{
            color: %1$s;
		}
	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $font_title_color ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_title_font_color', 18 );











//space
function ganesa_space() {
    $default          = '';
    $ganesa_space     = get_post_meta(get_the_ID(), 'layout_space',true);

    // Don't do anything if the current color is the default.
    if ( $ganesa_space === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
       .page-content{
		    padding:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_space ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_space', 23 );

function ganesa_color_footer() {
    $default         = '';
    $ganesa_color_footer       = get_theme_mod('ganesa_color_footer',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_color_footer === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
        #na-footer .widgettitle,#na-footer ul li,#na-footer ul li a,#na-footer ul li b,[class*="ion-social-"],#na-footer,#na-footer .footer-bottom .coppy-right a
		{
		    color:%1$s;
		}
		[class*="ion-social-"]{
		    border-color:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_color_footer ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_color_footer', 23 );

function ganesa_bg_footer() {
    $default         = '';
    $ganesa_bg_footer       = get_theme_mod('ganesa_bg_footer',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_bg_footer === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
        #na-footer,#na-footer .footer-bottom,#na-footer .footer-center
		{
		    background:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_bg_footer ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_bg_footer', 24 );

function ganesa_color_topbar() {
    $default         = '';
    $ganesa_color_topbar       = get_theme_mod('ganesa_color_topbar',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_color_topbar === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
        .wrap-select-currency::after,
        .wrap-select-country::after,
        #ganesa-top-navbar,
        #ganesa-top-navbar .topbar-left a,
        #ganesa-top-navbar a
		{
		    color:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_color_topbar ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_color_topbar', 25 );

function ganesa_bg_topbar() {
    $default         = '';
    $ganesa_bg_topbar       = get_theme_mod('ganesa_bg_topbar',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_bg_topbar === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
		#ganesa-top-navbar{
		    background:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_bg_topbar ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_bg_topbar', 25 );

function ganesa_bg_header() {
    $default         = '';
    $ganesa_bg_header       = get_theme_mod('ganesa_bg_header',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_bg_header === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
		#ganesa-header,.header-drawer #ganesa-header,.header-content-menu{
		    background:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_bg_header ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_bg_header', 26 );

function ganesa_color_menu() {
    $default         = '';
    $ganesa_color_menu       = get_theme_mod('ganesa_color_menu',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_color_menu === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
		.menu-drawer #na-menu-primary ul.mega-menu > li > a,
		#na-menu-primary ul > li[class*="-has-children"] > a::before,
		.menu-drawer #na-menu-primary ul > li[class*="-has-children"] > a::before,
		.ganesa_icon-bar,
        #na-menu-primary ul.mega-menu > li > a
		{
		    color:%1$s;
		}

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_color_menu ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_color_menu', 27 );


function ganesa_body_background() {
    $default         = '';
    $ganesa_bg_body       = get_theme_mod('ganesa_bg_body',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_bg_body === $default ) {
        return;
    }

    $css = '
		/* Custom  color title  */
		body,
		.sliders-column4 .post-item .entry-header,.entry-title,.post-grid .entry-title,
		.tags-wrap .tags a,.post-half .article-content
		{
		    background:%1$s;
		}

	';
    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_bg_body ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_body_background', 28 );

/**
 * Enqueues front-end CSS for the Primary  Color .
 *
 * @since ganesa
 *
 * @see wp_add_inline_style()
 */

function ganesa_primary_body() {
    $default         = '';
    $ganesa_primary_color       = get_theme_mod('ganesa_primary_body',$default);

    // Don't do anything if the current color is the default.
    if ( $ganesa_primary_color === $default ) {
        return;
    }

    $css = '
        .btn-outline .badge,
        .btn-inverse,
        .btn-inverse:hover, .btn-inverse:focus, .btn-inverse:active, .btn-inverse.active,
        .open .btn-inverse.dropdown-toggle,
        .btn-inverse.disabled, .btn-inverse.disabled:hover, .btn-inverse.disabled:focus, .btn-inverse.disabled:active, .btn-inverse.disabled.active, .btn-inverse[disabled], .btn-inverse[disabled]:hover, .btn-inverse[disabled]:focus, .btn-inverse[disabled]:active, .btn-inverse[disabled].active, fieldset[disabled] .btn-inverse, fieldset[disabled] .btn-inverse:hover, fieldset[disabled] .btn-inverse:focus, fieldset[disabled] .btn-inverse:active, fieldset[disabled] .btn-inverse.active,
        .btn-varian,
        .button:hover, .button:focus, .button:active, .button.active ,
        .open .button.dropdown-toggle,
        .page-content .vc_btn3.vc_btn3-style-custom ,
        .page-content .vc_btn3.vc_btn3-style-custom:hover, .page-content .vc_btn3.vc_btn3-style-custom:focus, .page-content .vc_btn3.vc_btn3-style-custom:active, .page-content .vc_btn3.vc_btn3-style-custom.active ,
        #loadmore-button:hover,
        .yith-wcwl-wishlistexistsbrowse a:after ,
        .quick-view a ,
        .btn-checkout ,
        .btn-order,
        .slick-prev:hover,
        .slick-next:hover,
        #calendar_wrap #today ,
        .expand-icon:hover::after, .expand-icon:hover::before,
        .ganesa_icon:hover .ganesa_icon-bar,
        .scrollup:hover,
        .widget_layered_nav ul li.chosen > a:before, .widget_layered_nav_filters ul li.chosen > a:before,
        .widget_layered_nav ul li a:hover:before, .widget_layered_nav_filters ul li a:hover:before,
        .onsale,
        .blog-recent-post .na-grid .bg_gradients > a ,
        .box-list .link-more a:hover,
        .post-format .ti-control-play:hover, .post-format .ti-camera:hover, .post-format .ti-headphone:hover, .post-format .ti-quote-left:hover,
        .tags a:hover,
        div.affect-border:before, div.affect-border:after,
        div.affect-border-inner:before,
        div.affect-border-inner:after,
        .nano > .nano-pane > .nano-slider,
        .btn-primary,.btn-primary:hover,
        .entry_pagination .page-numbers:hover i,
        .btn-variant:hover, .btn-variant:focus, .btn-variant:active, .btn-variant.active,
        .newsletters .btn-newsletter,
        .btn-read:hover,button, html input[type="button"], input[type="reset"], input[type="submit"],
        input[type="submit"]:hover
        {
            background-color: %1$s;
        }

        .link:hover,
        a:hover, a:focus,
        .tags-list a:hover, .tagcloud a:hover,
        .btn-outline,
        .btn-outline:hover, .btn-outline:focus, .btn-outline:active, .btn-outline.active,
        .open .btn-outline.dropdown-toggle,
        .btn-inverse .badge,
        .btn-variant .badge,
        .nav-tabs > li.active > a ,
        .nav-tabs > li.active > a, .nav-tabs > li.active > a:hover, .nav-tabs > li.active > a:focus,
        .na-filter-wrap #na-filter .widget .na-ajax-load a:hover ,
        .na-filter-wrap .chosen,
        .na-filter-wrap .na-remove-attribute,
        .btn-mini-search:hover,
        #na-top-navbar #language-switch ul > li span:hover,
        .alert a,
        .share-links .count-share:hover ,
        .share-links .count-share i,
        #sb_instagram #sbi_load .fa, #sb_instagram .sbi_follow_btn .fa,
        .sidebar a:hover,
        .sidebar ul li.current-cat > a,
        .sidebar #recentcomments li > a,
        #na-footer .footer-bottom .coppy-right a:hover ,
        .contact .fa,
        #ganesa-quickview .price,
        .is-active > a,
        #ganesa-top-navbar a:hover, #ganesa-top-navbar a:focus ,
        #ganesa-top-navbar .topbar-left a:hover,
        #na-footer ul li a:hover ,
        .widget_layered_nav ul li.chosen, .widget_layered_nav_filters ul li.chosen,
        .widget_layered_nav ul li.chosen > a, .widget_layered_nav_filters ul li.chosen > a,
        .widget_layered_nav ul li:hover .count, .widget_layered_nav_filters ul li:hover .count ,
        .widget.recent_blog .entry-title a:hover,
        .name a:hover ,
        .price,
        .price ins,
        .list-view .price,
        .sidebar .widget_tabs_post .widget-title li.active a,
        .sidebar .widget_tabs_post .widget-title li a:hover, .sidebar .widget_tabs_post .widget-title li a:focus, .sidebar .widget_tabs_post .widget-title li a:active ,
        .widget.about .ganesa-social-icon a:hover,
        .post-list .entry-header .posted-on a:hover,
        .post-list .author strong:hover,
        .box-list .name-category,
        .box-list .name-category > a,
        .post-cat ,
        .entry-title > a:hover,
        .entry-avatar .author-title,
        .entry-avatar .author-link,
        .post-comment .fa,
        #comments .text-user > a,
        .post-related .author-link:hover,
        .item-related .post-title > a:hover ,
        .entry_pagination .pagination .fa,
        .entry_pagination .pagination .page-numbers:hover .fa ,
        .entry_pagination .page-numbers i,
        .entry_pagination .page-numbers:hover ,
        .entry_pagination .page-numbers .btn-prev,
        .entry_pagination .page-numbers .btn-next,
        .entry-content a,
        .pagination .current,.post-list .article-meta a:hover,.pagination .nav-links a:hover,
        .post-grid .article-meta a:hover,
        #na-menu-primary ul > li.current-menu-item:hover > a, #na-menu-primary ul > li.current-menu-item:focus > a,
        #na-menu-primary ul > li.current-menu-item > a,
        #na-menu-primary ul > li > a:hover, #na-menu-primary ul > li > a:focus,
        #na-menu-primary ul > li.current-menu-item,
        #na-menu-primary ul.mega-menu > li > a:hover, #na-menu-primary ul.mega-menu > li > a:focus,
        #na-menu-primary ul > li:hover[class*="-has-children"] > a:before,
        #na-menu-primary ul > li > ul li[class*="-has-children"]:hover:after,
        .post-tran .entry-title a:hover,
        .post-tran .article-meta a:hover, .post-tran .article-meta .fa:hover,
        .box-videos .video-carousel .post-item:hover .entry-title > a,
        .byline:hover i,
        .posted-on:hover i,
        .slick-dots li button:hover, .slick-dots li button:focus,
        .box-videos .video-carousel .slick-dots li.slick-active button::before, .box-videos .video-carousel .slick-dots li:hover button::before,
        .slider-sidebar .entry-title:hover,.slider-sidebar:hover .entry-title,.article-meta a:hover,
        .post-cat a,.style_white #na-menu-primary ul > li.current-menu-item > a,
        .style_white.header-center #na-menu-primary ul > li.current-menu-item > a, .style_white .header-center #na-menu-primary ul > li.current-menu-item:focus > a,
        .box-sliders-half .slick-dots li button::before,.style_white .btn-mini-search:hover
        {
          color: %1$s;
        }

       .btn-outline,
        .btn-outline:hover, .btn-outline:focus, .btn-outline:active, .btn-outline.active,
        .open .btn-outline.dropdown-toggle,
        .btn-outline.disabled, .btn-outline.disabled:hover, .btn-outline.disabled:focus, .btn-outline.disabled:active, .btn-outline.disabled.active, .btn-outline[disabled], .btn-outline[disabled]:hover, .btn-outline[disabled]:focus, .btn-outline[disabled]:active, .btn-outline[disabled].active, fieldset[disabled] .btn-outline, fieldset[disabled] .btn-outline:hover, fieldset[disabled] .btn-outline:focus, fieldset[disabled] .btn-outline:active, fieldset[disabled] .btn-outline.active,
        .btn-inverse,
        .btn-inverse:hover, .btn-inverse:focus, .btn-inverse:active, .btn-inverse.active,
        .open .btn-inverse.dropdown-toggle,
        .button:hover, .button:focus, .button:active, .button.active ,
        .open .button.dropdown-toggle,
        .form-control:focus,
        .page-links span.page-numbers:hover ,
        #loadmore-button:hover,
        .page-content .vc_btn3.vc_btn3-style-custom,
        .page-content .vc_btn3.vc_btn3-style-custom:hover, .page-content .vc_btn3.vc_btn3-style-custom:focus, .page-content .vc_btn3.vc_btn3-style-custom:active, .page-content .vc_btn3.vc_btn3-style-custom.active,
        .btn-checkout ,
        .btn-order,
        .post-format .ti-control-play:hover, .post-format .ti-camera:hover, .post-format .ti-headphone:hover, .post-format .ti-quote-left:hover,
        blockquote,.btn-primary,
        .btn-variant:hover, .btn-variant:focus, .btn-variant:active, .btn-variant.active,
        .btn-read:hover,
        button, html input[type="button"], input[type="reset"], input[type="submit"],input[type="submit"]:hover
        {
          border-color: %1$s;
        }
        .entry-content a{
                box-shadow: 0 -2px 0 %1$s inset;
        }
        .button:hover{
            color:white;
        }

	';

    wp_add_inline_style( 'ganesa-css', sprintf( $css, $ganesa_primary_color ) );
}
add_action( 'wp_enqueue_scripts', 'ganesa_primary_body', 29 );
?>