<?php
/**
 * @package     wide
 * @version     1.0
 * @author      NanoAgency
 * @link        http://www.nanoagency.co
 * @copyright   Copyright (c) 2016 NanoAgency
 * @license     GPL v2
 */

class ganesa_demo extends WP_Widget{

    /*function construct*/
    public function __construct() {
        parent::__construct(
            'demo',esc_html__('+NA: Wizard','ganesa'),
            array('description'=>esc_html__('Update news from your demo', 'ganesa'))
        );
    }
    /**
     * font-end widgets
     */
    public function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);

        echo ent2ncr($args['before_widget']);

        if($title) {
            echo ent2ncr($args['before_title']) . esc_html($title) . ent2ncr($args['after_title']);
        }
        wp_enqueue_script('tweets-widgets');
        ?>
        <div class="ganesa-wizard">
            <script type="text/javascript">
                baseUrl = "https://widgets.cryptocompare.com/";
                var scripts = document.getElementsByTagName("script");
                var embedder = scripts[ scripts.length - 1 ];
                (function (){
                    var appName = encodeURIComponent(window.location.hostname);
                    if(appName==""){appName="local";}
                    var s = document.createElement("script");
                    s.type = "text/javascript";
                    s.async = true;
                    var theUrl = 'https://widgets.cryptocompare.com/serve/v1/coin/chart?fsym=BTC&tsym=USD';
                    s.src = theUrl + ( theUrl.indexOf("?") >= 0 ? "&" : "?") + "app=" + appName;
                    embedder.parentNode.appendChild(s);
                })();
            </script>
        </div>
        <?php
        echo ent2ncr($args['after_widget']);
    }

    /**
     * Back-end widgets form
     */
    public function form($instance){
        $instance =   wp_parse_args($instance,array(
            'title'             =>  esc_html__('Latest Tweets', 'ganesa'),
            'username'          =>  'themenano',
            'width'             =>  '300',
            'height'            =>  '250',
            'theme'             =>  'dark',
        ));
        ?>
        <p>
            <label for=<?php echo esc_attr($this->get_field_id('title')); ?>><?php echo esc_html_e('Title:','ganesa') ; ?></label>
            <input type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
        </p>

        <?php
    }

    /**
     * function update widget
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title']                      = $new_instance['title'];
        return $instance;
    }
}
function ganesa_demo(){
    register_widget('ganesa_demo');
}
add_action('widgets_init','ganesa_demo');
?>