<?php
if (!function_exists('nano_shortcode_blog')) {
    function nano_shortcode_blog($atts)
    {
        $atts = shortcode_atts(array(
            'title'                 => '',
            'post_layout'           => 'list',
            'title_style'           => 'left',
            'columns'               => 1,
            'category_name'         => '',
            'image_box'             => '',
            'number'                => 8,
            'view_more'             => true,
            'number_words'          =>'25',
            'share_button'          =>'yes',
            'pagination'            =>'loadMore',
            'ads_layout'            =>'large-rectangle',
            'style_border'          => false,
            'type_filter'           => 'cat_filter',
            'list_type'             => 'post_latest,post_featured,post_view',
            'el_class'              => '',

        ), $atts);

        ob_start();
        nano_template_part('shortcode', 'blog' , array('atts' => $atts));
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }
}
add_shortcode('blog', 'nano_shortcode_blog');

add_action('vc_before_init', 'nano_blog_integrate_vc');

if (!function_exists('nano_blog_integrate_vc')) {
    function nano_blog_integrate_vc()
    {
        $show_tab = array(
            array('post_latest', __('Latest Posts', 'nano')),
            array('post_featured', __('Featured Posts', 'nano' )),
            array('post_view', __('Most Viewed', 'nano' )),
        );
        vc_map(array(
            'name' => __('NA Blog Content', 'nano'),
            'base' => 'blog',
            'category' => __('NA', 'nano'),
            'icon' => 'vc_icon-vc-hoverbox',
            "params" => array(
                array(
                    "type" => "textfield",
                    "heading" => __("Title", 'nano'),
                    "param_name" => "title",
                    "admin_label" => true
                ),
                array(
                    "type" => "dropdown",
                    "heading" => __("Title Style", 'nano'),
                    "param_name" => "title_style",
                    'std' => 'left',
                    "value" => array(
                        esc_html__('Left', 'nano' )     => 'left',
                        esc_html__('Center', 'nano' )   => 'center',
                        esc_html__('Inside', 'nano' )   => 'inside',
                    )
                ),
                array(
                    'type' => 'nano_image_radio',
                    'heading' => esc_html__('Layout a post', 'nano'),
                    'value' => array(
                        esc_html__(NANO_PLUGIN_URL.'assets/images/box-taxonomy.jpg', 'nano')   => 'grid',
                        esc_html__(NANO_PLUGIN_URL.'assets/images/box-list.jpg', 'nano')       => 'list',
                        esc_html__(NANO_PLUGIN_URL.'assets/images/box-tran.jpg', 'nano')       => 'trans',
                        esc_html__(NANO_PLUGIN_URL.'assets/images/box-slax.jpg', 'nano')       => 'grid-des',
                    ),
                    'group' => __( 'Layout Settings', 'nano' ),
                    'width' => '100px',
                    'height' => '70px',
                    'param_name' => 'post_layout',
                    'std' => 'list',
                ),
                array(
                    "type" => "nano_post_categories",
                    "heading" => __("Category IDs", 'nano'),
                    "description" => __("Select category", 'nano'),
                    "param_name" => "category_name",
                    "admin_label" => true,
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Posts Count", 'nano'),
                    "param_name" => "number",
                    "value" => '8'
                ),
                array(
                    "type" => "dropdown",
                    "heading" => __("Pagination ", 'nano'),
                    "param_name" => "pagination",
                    "value" => array(
                        __('Pagination', 'nano' ) => 'pagination',
                        __('Load more button', 'nano' ) => 'loadMore',
                        __('Lazy Loading', 'nano' ) => 'lazyLoading',
                    ),
                    'group' => __( 'Layout Settings', 'nano' ),
                    'std' => 'loadMore',
                ),

                array(
                    "type" => "attach_image",
                    "description" => esc_html__("upload an image.", 'nano'),
                    "param_name" => "image_box",
                    "value" => '',
                    'heading'	=> esc_html__('Background for the Title Inside', 'nano' ),
                ),
                array(
                    'type' => 'checkbox',
                    'heading' => __("Create Space", 'nano'),
                    "description" => __("Create gap space and border", 'nano'),
                    'param_name' => 'style_border',
                    'std' => 'no',
                    'value' => array(__('Yes', 'nano') => 'yes'),
                ),

                array(
                    'type' => 'textfield',
                    'heading' => __( 'Extra class name', 'nano' ),
                    'param_name' => 'el_class',
                    'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'nano' )
                )
            )
        ));
    }
}
