<?php

$css_class          = vc_shortcode_custom_css_class( $atts['css'], ' ' );
$img_size_f         = wpb_getImageBySize( array( 'attach_id' => (int) $atts['image_f'], 'thumb_size' => '590x590' ) );
$img_size_t         = wpb_getImageBySize( array( 'attach_id' => (int) $atts['image_t'], 'thumb_size' => '685x350' ) );
$items              = (array) vc_param_group_parse_atts($atts['items']);

?>
<div class="block na-infoAbout box <?php echo esc_attr($css_class); ?> clearfix">
            <div class="entry-image style-2 clearfix">
                <?php if ( $atts['des_f'] ) {?>
                    <span class="des_f">
                        <?php echo esc_html( $atts['des_f'] ); ?>
                    </span>
                <?php }?>
                <?php if($atts['image_f']) { ?>
                    <div class="image_f">
                        <?php echo $img_size_f['thumbnail'];?>
                    </div>
                <?php } ?>

            </div>
            <div class="entry-content style-2 clearfix">
                <div class="image-box clearfix">
                    <?php if($atts['image_t']) { ?>
                        <div class="image_t">
                            <?php echo $img_size_t['thumbnail'];?>
                        </div>
                    <?php } ?>
                </div>
                <div class="content-box clearfix">
                    <?php if ( $atts['title_box'] ) {?>
                        <h3 class="title-block title-box">
                            <?php echo esc_html( $atts['title_box'] ); ?>
                        </h3>
                    <?php }?>

                    <?php if(isset($atts['content_box'])){?>
                        <div  class="des-box"><?php echo esc_html($atts['content_box']);?> </div>
                    <?php }?>

                    <ul class="list-social clearfix">
                        <?php foreach ( $items as $item ) {?>
                            <?php
                            if ( isset($item['link']) ) {?>
                                <li>
                                    <a class="" href="<?php echo esc_url($item['link']);?>">
                                        <i class="<?php echo esc_attr( $item['icon'] ) ;?>"></i>
                                    </a>
                                </li>
                            <?php } ?>
                        <?php }?>
                    </ul>
                </div>

            </div>

</div>