<?php
/**
 * The default template for displaying content
 *
 * @author      Nanoliberty
 * @link        http://nanoliberty.co
 * @copyright   Copyright (c) 2015 Nanoliberty
 * @license     GPL v2
 */

$format = get_post_format();
$style_css='';
$arr = array(
    'post_type'           => 'post',
    'post_status'         => 'publish',
    'orderby'             => 'date',
    'fields'        	  => 'ids',
    'order'               => 'DESC',
    'ignore_sticky_posts' => true,
    'category_name'       => $atts['category_name'],
    'posts_per_page'      =>($atts['number'] > 0) ? $atts['number'] : get_option('posts_per_page')
);
$meta_query[] = array(
    'key'   => '_featured',
    'value' => 'yes'
);
$arr['meta_query'] = $meta_query;
$result_query = new WP_Query( $arr );
$ID_array = $result_query->posts;

$args = array(
    'post_type'           => 'post',
    'post_status'         => 'publish',
    'orderby'             => 'date',
    'order'               => 'DESC',
    'post__not_in'        => $ID_array,
    'ignore_sticky_posts' => true,
    'category_name'       => $atts['category_name'],
    'posts_per_page'      =>($atts['number'] > 0) ? $atts['number'] : get_option('posts_per_page')
);

$args['paged'] = (nano_get_query_var('paged')) ? nano_get_query_var('paged') : 1;
$the_query = new WP_Query($args);

$num_pages = $the_query->max_num_pages;

$class_pagination='pagination';
if($atts['pagination']=='loadMore'){
    $class_pagination='loadMore';
}
if($atts['pagination']=='lazyLoading'){
    $class_pagination='infiniteScroll';
}
$style_border='style-no';
if($atts['style_border']){
    $style_border='style-border';
}
if(isset($atts['category_name']) & !empty($atts['category_name'])){
    $categories = explode( ',', $atts['category_name'] );
} else{
    $categories=get_the_category();
}
$i=1;

if($atts['image_box']) {
    $image_link         = wp_get_attachment_image_src($atts['image_box'],'ganesa-blog-grid');
    $background_image   ="background-image:url('$image_link[0]')";
    $style_css          ='style = '.$background_image.'';
}

?>

<div class="<?php echo 'wrapper-posts box-recent type-'.esc_attr($class_pagination).' layout-' . esc_attr($atts['post_layout']).' '.esc_attr($style_border); ?>"
     data-layout="<?php echo esc_attr($atts['post_layout']);?>"
     data-paged="<?php echo esc_attr($num_pages);?>"
     data-cat="<?php echo esc_attr($atts['category_name'])?>"
     data-number="<?php echo esc_attr($atts['number'])?>"
     data-ads="">

            <?php if($atts['post_layout'] == 'list'){?>
                <?php if ($atts['title']) { ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-left"><?php echo esc_html($atts['title']); ?></h2>
                    </div>
                <?php } ?>
                    <div  class="archive-blog affect-isotope row clearfix">
                        <?php if ($the_query->have_posts()):
                            while ($the_query->have_posts()): $the_query->the_post(); ?>
                                <div class="col-item col-md-12 col-sm-12 col-xs-12">
                                    <?php na_part_templates('layout/content-list');?>
                                </div>
                                <?php $i++; endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
            <?php }

            elseif($atts['post_layout'] == 'trans'){?>
                <?php if ($atts['title'] && $atts['title_style'] != 'inside') { ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-left"><?php echo esc_html($atts['title']); ?></h2>
                    </div>
                <?php } ?>
                <div class="tab-content">
                    <div class="content-category cats-trans">
                    <div class="rows affect-isotope clearfix">
                        <?php $i=1;?>
                        <?php if ($atts['title'] && $atts['title_style'] == 'inside') { ?>
                            <div class="item-post item-title col-item item-trans" >
                                <div class="inside-item" <?php echo esc_attr($style_css);?>>
                                    <div class="inside-inner">
                                        <h2 class="title-left" ><?php echo esc_html($atts['title']); ?></h2>
                                    </div>
                                </div>
                                <?php $i=2;?>
                            </div>
                        <?php } ?>

                        <?php if ($the_query->have_posts()):
                            while ($the_query->have_posts()): $the_query->the_post(); ?>
                                <?php if($i==2 || ($i==7) ||($i==8) ||(($i-8)% 4 == 0)):?>
                                    <div class="item-post col-item item-trans-vertical">
                                        <?php get_template_part( 'templates/layout/content-trans-vertical'); ?>
                                    </div>
                                <?php else:?>
                                    <div class="item-post col-item item-trans">
                                        <?php get_template_part( 'templates/layout/content-trans'); ?>
                                    </div>
                                <?php endif;?>
                                <?php $i++; endwhile;
                        endif;
                        wp_reset_postdata();?>

                    </div>
                </div>
                </div>
            <?php }

            elseif($atts['post_layout'] == 'grid'){?>
                <?php if ($atts['title']) { ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-left"><?php echo esc_html($atts['title']); ?></h2>
                    </div>
                <?php } ?>
                <div class="tab-content">
                    <div class="content-category cats-grid">
                            <div class="rows affect-isotope clearfix">
                                <?php
                                if ($the_query->have_posts()):
                                    $n=1;
                                    while ($the_query->have_posts()): $the_query->the_post(); ?>
                                        <?php if($n%2==0):?>
                                            <div class="item-post col-item item-grid-vertical">
                                                <?php get_template_part( 'templates/layout/content-grid-vertical'); ?>
                                            </div>
                                        <?php else:?>
                                            <div class="item-post col-item item-grid-des">
                                                <?php get_template_part( 'templates/layout/content-grid'); ?>
                                            </div>
                                        <?php endif;?>
                                        <?php $n++; endwhile;
                                endif;
                                wp_reset_postdata(); ?>
                            </div>
                    </div>
                </div>
            <?php }

            elseif($atts['post_layout'] == 'grid-des'){?>
                <div class="tab-content">
                    <div class="content-category cats-grid-des">
                        <div class="rows affect-isotope clearfix">
                            <div class="item-post col-item item-grid-des col-item-title">

                                <?php if ($atts['title']) { ?>
                                        <h2 class="title-cat"><?php echo esc_html($atts['title']); ?></h2>
                                <?php } ?>

                            </div>
                            <?php
                            if ($the_query->have_posts()):
                                $n=1;
                                while ($the_query->have_posts()): $the_query->the_post(); ?>
                                    <?php if($n%5==0):?>
                                        <div class="item-post col-item item-grid-list clearfix">
                                            <?php get_template_part( 'templates/layout/content-list'); ?>
                                        </div>
                                    <?php elseif(($n-1)%5==0 || ($n-2)%5==0):?>
                                        <div class="item-post col-item item-grid-des nano-left">
                                            <?php get_template_part( 'templates/layout/content-grid-des'); ?>
                                        </div>
                                    <?php else:?>
                                        <div class="item-post col-item item-grid-des">
                                            <?php get_template_part( 'templates/layout/content-grid-des'); ?>
                                        </div>
                                    <?php endif;?>
                                    <?php $n++; endwhile;
                            endif;
                            wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
            <?php }

            else{?>
                <?php if ($atts['title']) { ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-left"><?php echo esc_html($atts['title']); ?></h2>
                    </div>
                <?php } ?>
                <div  class="archive-blog affect-isotope row clearfix">
                    <?php if ($the_query->have_posts()):
                        while ($the_query->have_posts()): $the_query->the_post(); ?>

                            <div class="col-item col-md-12 col-sm-12 col-xs-12">
                                <?php na_part_templates('layout/content-list');?>
                            </div>

                            <?php $i++; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            <?php } ?>


    <?php
    //paging
    if($atts['pagination']=='loadMore'){?>
        <span id="loadMore" class="button">
            <?php esc_html_e('Load More','nano');?>
        </span>
    <?php }
    elseif($atts['pagination']=='lazyLoading'){  ?>
        <span id="nextPage" class="button">
        </span>
        <?php
    }
    else{
        nano_pagination(3, $the_query);
    }

    ?>
</div>