<?php
/**
 * The default template for displaying content
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */
$add_rtl="false";
if(is_rtl()){
    $add_rtl="true";
}
$format = get_post_format();
$add_class=$class='';
$args = array(
    'category_name'  => $atts['category_name'],
    'post_type'      => 'post',
    'post_status'    => 'publish',
    'posts_per_page' => $atts['number_post'],
    'tax_query' => array(
        array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array( 'post-format-video' )
        )
    )
);
$auto='0';
if($atts['auto_play']=='yes'){
    $auto='1';
}
switch ($atts['show_post']) {
    case '1':
        $class .= "col-md-12 col-xs-12";
        break;
    case '2':
        $class .= "col-xs-12 col-sm-6 col-md-6";
        break;
    case '3':
        $class .= "col-xs-12 col-sm-6 col-md-4";
        break;
    case '4':
        $class .= "col-xs-12 col-sm-6 col-md-3";
        break;
    default:
        $class .= "col-xs-12 col-sm-6 col-md-4";
        break;
}

$the_query = new WP_Query($args);
$count  = $the_query->post_count;
$cats   =  explode(",", $atts['category_name']);
?>

<div class="box-videos box clearfix">


    <?php switch ($atts['layout_types']) {
        case 'carousel':?>
            <div class="box-video video-carousel clearfix">
                <?php if ($atts['title']){ ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-cat "><?php echo esc_html($atts['title']); ?></h2>
                        <a class="btn-more" href="<?php echo esc_url( home_url( '/type/video/' ) ); ?>"><?php esc_html_e('View all','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                    </div>
                <?php } ?>
                <div class="article-carousel archive-blog " data-rtl="<?php echo esc_attr($add_rtl);?>" data-number="<?php echo esc_attr($atts['show_post']);?>"  data-dots="false" data-table="2" data-mobile = "2" data-mobilemin = "2" data-arrows="true">
                    <?php
                    $n=1;
                    while ( $the_query->have_posts() ) {
                        $the_query->the_post(); ?>
                        <?php if(has_post_format('video')) :?>
                            <div class="post-grid post-item clearfix">
                                <div class="post-image <?php if ($n == 1) echo esc_attr('active');?>" data-name="video<?php echo esc_attr($n);?>">
                                    <div class="post-image-arg">
                                        <a href="<?php echo esc_url( get_permalink() );?>">
                                            <?php the_post_thumbnail('ganesa-blog-video'); ?>
                                        </a>
                                        <span class="bgr-item"></span>
                                        <i class="fa fa-play" aria-hidden="true"></i>
                                    </div>
                                </div>
                                <div class="article-content clearfix">
                                    <div class="entry-header">
                                        <header class="entry-header-title">
                                            <?php
                                            the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                                            ?>
                                        </header>
                                        <div class="article-meta clearfix">
                                            <?php ganesa_entry_meta(); ?>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        <?php  endif;  $n++;?>
                    <?php }
                    wp_reset_postdata();?>

                </div>
            </div>
            <?php break;
        case 'grid':?>
            <div class="box-video video-grid layout-grid clearfix">
                <?php if ($atts['title'] && $atts['title_style'] !='inside'){ ?>
                    <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                        <h2 class="title-cat "><?php echo esc_html($atts['title']); ?></h2>
                        <a class="btn-more" href="<?php echo esc_url( home_url( '/type/video/' ) ); ?>"><?php esc_html_e('View all','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                    </div>
                <?php } ?>
                <div class="article-grid row">

                    <?php if ($atts['title'] && $atts['title_style'] =='inside'){ ?>
                        <div class="item-video <?php echo esc_attr($class);?>">
                            <div class="box-title <?php echo esc_attr($atts['title_style']);?> clearfix">
                                <h2 class="title-cat "><?php echo esc_html($atts['title']); ?></h2>
                                <a class="btn-more" href="<?php echo esc_url( home_url( '/type/video/' ) ); ?>"><?php esc_html_e('View all','nano')?><i class="ion-ios-arrow-thin-right"></i></a>
                            </div>
                        </div>
                    <?php } ?>

                    <?php
                    while ( $the_query->have_posts() ) {
                        $the_query->the_post(); ?>
                        <div class="description-hidden item-video clearfix <?php echo esc_attr($class);?>">
                            <?php if(has_post_format('video')) :?>
                            <div class="post-grid post-item clearfix">
                                <div class="post-image">
                                    <div class="post-image-arg">
                                        <a href="<?php echo esc_url( get_permalink() );?>">
                                            <?php the_post_thumbnail('ganesa-blog-video'); ?>
                                        </a>
                                        <span class="bgr-item"></span>
                                        <i class="fa fa-play" aria-hidden="true"></i>
                                    </div>
                                </div>
                                <div class="article-content clearfix">
                                    <div class="entry-header">
                                        <header class="entry-header-title">
                                            <?php
                                            the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                                            ?>
                                        </header>
                                        <div class="article-meta clearfix">
                                            <?php ganesa_entry_meta(); ?>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        <?php  endif;?>
                        </div>
                    <?php }
                    wp_reset_postdata();?>

                </div>
            </div>
            <?php break;
        default:?>
            <div class="box-video video-carousel clearfix">
                <div class="article-carousel" data-rtl="<?php echo esc_attr($add_rtl);?>" data-number="<?php echo esc_attr($atts['show_post']);?>"  data-dots="true" data-table="2" data-mobile = "1" data-mobilemin = "1" data-arrows="false">
                    <?php
                    $n=1;
                    while ( $the_query->have_posts() ) {
                        $the_query->the_post(); ?>

                        <?php if(has_post_format('video')) :?>
                            <div class="post-grid post-item clearfix">
                                <div class="post-image <?php if ($n == 1) echo esc_attr('active');?>" data-name="video<?php echo esc_attr($n);?>">
                                    <div class="post-image-arg">
                                        <a href="<?php echo esc_url( get_permalink() );?>">
                                            <?php the_post_thumbnail('ganesa-blog-grid'); ?>
                                        </a>

                                        <i class="fa fa-play" aria-hidden="true"></i>
                                    </div>
                                </div>
                                <div class="article-content clearfix">
                                    <header class="entry-header-title">
                                        <?php
                                        the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                                        ?>
                                    </header>
                                    <div class="article-meta clearfix">
                                        <?php ganesa_entry_meta(); ?>
                                    </div>
                                </div>

                            </div>
                        <?php  endif;  $n++;?>
                    <?php }
                    wp_reset_postdata();?>

                </div>
            </div>
            <?php break;
    } ?>
</div>


