<?php

namespace Devnet\FSL\Includes;

/**
 * SVG Icons class
 * @since 2.6.0
 */

class Icons
{

    /**
     * User Interface icons – svg sources.
     *
     * @since 2.6.0
     *
     * @var array
     */
    protected static $icons = [

        'delivery-truck-1' => '<svg version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g><path fill="#000000" d="M116.683,354.34c-26.836,0-48.607,21.764-48.607,48.6c0,26.85,21.771,48.614,48.607,48.614c26.844,0,48.608-21.764,48.608-48.614C165.29,376.104,143.526,354.34,116.683,354.34z M116.683,424.826c-12.08,0-21.872-9.799-21.872-21.886c0-12.073,9.792-21.865,21.872-21.865c12.08,0,21.872,9.792,21.872,21.865C138.554,415.027,128.762,424.826,116.683,424.826z"/><path fill="#000000" d="M403.8,354.34c-26.836,0-48.6,21.764-48.6,48.6c0,26.85,21.764,48.614,48.6,48.614c26.843,0,48.606-21.764,48.606-48.614C452.406,376.104,430.643,354.34,403.8,354.34z M403.8,424.826c-12.073,0-21.865-9.799-21.865-21.886c0-12.073,9.792-21.865,21.865-21.865c12.079,0,21.871,9.792,21.871,21.865C425.671,415.027,415.879,424.826,403.8,424.826z"/><path fill="#000000" d="M200.127,128.622H90.502c-3.561,0-6.957,1.582-9.23,4.331l-78.48,94.163C0.986,229.268,0,231.994,0,234.815v82.595v43.189c0,6.648,5.389,12.029,12.03,12.029h36.844c11.626-25.9,37.621-44.024,67.81-44.024c30.196,0,56.183,18.124,67.81,44.024h27.671V140.652C212.163,134.003,206.767,128.622,200.127,128.622z M43.931,236.052c0-2.849,0.978-5.612,2.777-7.82l50.103-61.694c2.36-2.907,5.9-4.59,9.633-4.59h49.083c6.848,0,12.404,5.554,12.404,12.411v70.011c0,6.849-5.555,12.404-12.404,12.404H56.334c-6.85,0-12.404-5.554-12.404-12.404V236.052z"/><path fill="#000000" d="M243.532,338.792c-3.741,0-6.763,3.03-6.763,6.77v20.303c0,3.735,3.022,6.763,6.763,6.763h92.466c6.382-14.209,17.072-26.023,30.419-33.836H243.532z"/><path fill="#000000" d="M504.381,338.792h-63.19c13.353,7.814,24.044,19.627,30.419,33.836h32.772c3.741,0,6.77-3.028,6.77-6.763v-20.303C511.151,341.822,508.122,338.792,504.381,338.792z"/><path fill="#000000" d="M497.568,60.446H252.043c-7.964,0-14.425,6.46-14.425,14.432v226.703c0,7.972,6.461,14.432,14.425,14.432h245.525c7.971,0,14.432-6.46,14.432-14.432V74.878C512,66.906,505.539,60.446,497.568,60.446z M458.27,134.09H291.355c-3.741,0-6.771-3.036-6.771-6.763v-13.533c0-3.741,3.03-6.77,6.771-6.77H458.27c3.735,0,6.763,3.029,6.763,6.77v13.533C465.033,131.054,462.005,134.09,458.27,134.09z M291.355,174.697H458.27c3.735,0,6.763,3.021,6.763,6.763V195c0,3.727-3.028,6.763-6.763,6.763H291.355c-3.741,0-6.771-3.036-6.771-6.763v-13.54C284.584,177.718,287.614,174.697,291.355,174.697z M291.355,242.369H458.27c3.735,0,6.763,3.022,6.763,6.763v13.533c0,3.727-3.028,6.77-6.763,6.77H291.355c-3.741,0-6.771-3.044-6.771-6.77v-13.533C284.584,245.391,287.614,242.369,291.355,242.369z"/></g></svg>',

        'delivery-truck-2' => '<svg viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg"> <g id="Layer_2" data-name="Layer 2"> <g id="invisible_box" data-name="invisible box"> <rect width="48" height="48" fill="none"/> </g> <g id="Health_Icons" data-name="Health Icons"> <g> <path d="M37.7,11.1A3,3,0,0,0,35.4,10H34.2l.3-1.7A3.1,3.1,0,0,0,33.9,6a3.2,3.2,0,0,0-2.2-1H7.8a2,2,0,0,0,0,4H30.3l-4,22.9a6.8,6.8,0,0,0-1,2.1H20.7A7,7,0,0,0,7.3,34H6.2l.5-2.9a2,2,0,0,0-1.6-2.3,2,2,0,0,0-2.3,1.6L2,34.7A2.8,2.8,0,0,0,2.7,37a2.8,2.8,0,0,0,2.1,1H7.3a7,7,0,0,0,13.4,0h4.6a7,7,0,0,0,13.4,0h2a3.2,3.2,0,0,0,3.1-2.7L46,22.5ZM14,39a3,3,0,0,1-3-3,3,3,0,0,1,6,0A3,3,0,0,1,14,39ZM33.5,14h1.3l5.9,8H32.1ZM32,39a3,3,0,0,1-3-3,3,3,0,0,1,6,0A3,3,0,0,1,32,39Zm8-5H38.7A7,7,0,0,0,32,29H30.9l.5-3.1h9.9Z"/> <path d="M4,15H14a2,2,0,0,0,0-4H4a2,2,0,0,0,0,4Z"/> <path d="M15,19a2,2,0,0,0-2-2H5a2,2,0,0,0,0,4h8A2,2,0,0,0,15,19Z"/> <path d="M6,23a2,2,0,0,0,0,4h6a2,2,0,0,0,0-4Z"/> </g> </g> </g></svg>',

        'delivery-truck-3' => '<svg viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg"> <g id="Layer_2" data-name="Layer 2"> <g id="invisible_box" data-name="invisible box"> <rect width="48" height="48" fill="none"/> </g> <g id="Layer_7" data-name="Layer 7"> <path d="M35.8,11a3.2,3.2,0,0,0-2.2-1H32V8a2.9,2.9,0,0,0-3-3H5A2.9,2.9,0,0,0,2,8V35a2.9,2.9,0,0,0,3,3H7.3a7,7,0,0,0,13.4,0h6.6a7,7,0,0,0,13.4,0H43a2.9,2.9,0,0,0,3-3V22.2Zm-2.7,3,7.3,8H32V14ZM14,39a3,3,0,1,1,3-3A2.9,2.9,0,0,1,14,39Zm20,0a3,3,0,1,1,3-3A2.9,2.9,0,0,1,34,39Z"/> </g> </g></svg>',

        'delivery-truck-4' => '<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 422.518 422.518" xml:space="preserve"><path d="M422.512,215.424c0-0.079-0.004-0.158-0.005-0.237c-0.116-5.295-4.368-9.514-9.727-9.514h-2.554l-39.443-76.258c-1.664-3.22-4.983-5.225-8.647-5.226l-67.34-0.014l2.569-20.364c0.733-8.138-1.783-15.822-7.086-21.638c-5.293-5.804-12.683-9.001-20.81-9.001h-209c-5.255,0-9.719,4.066-10.22,9.308l-2.095,16.778h119.078c7.732,0,13.836,6.268,13.634,14c-0.203,7.732-6.635,14-14.367,14H126.78c0.007,0.02,0.014,0.04,0.021,0.059H10.163c-5.468,0-10.017,4.432-10.16,9.9c-0.143,5.468,4.173,9.9,9.641,9.9H164.06c7.168,1.104,12.523,7.303,12.326,14.808c-0.216,8.242-7.039,14.925-15.267,14.994H54.661c-5.523,0-10.117,4.477-10.262,10c-0.145,5.523,4.215,10,9.738,10h105.204c7.273,1.013,12.735,7.262,12.537,14.84c-0.217,8.284-7.109,15-15.393,15H35.792v0.011H25.651c-5.523,0-10.117,4.477-10.262,10c-0.145,5.523,4.214,10,9.738,10h8.752l-3.423,35.818c-0.734,8.137,1.782,15.821,7.086,21.637c5.292,5.805,12.683,9.001,20.81,9.001h7.55C69.5,333.8,87.3,349.345,109.073,349.345c21.773,0,40.387-15.545,45.06-36.118h94.219c7.618,0,14.83-2.913,20.486-7.682c5.172,4.964,12.028,7.682,19.514,7.682h1.55c3.597,20.573,21.397,36.118,43.171,36.118c21.773,0,40.387-15.545,45.06-36.118h6.219c16.201,0,30.569-13.171,32.029-29.36l6.094-67.506c0.008-0.091,0.004-0.181,0.01-0.273c0.01-0.139,0.029-0.275,0.033-0.415C422.52,215.589,422.512,215.508,422.512,215.424z M109.597,329.345c-13.785,0-24.707-11.214-24.346-24.999c0.361-13.786,11.87-25.001,25.655-25.001c13.785,0,24.706,11.215,24.345,25.001C134.89,318.131,123.382,329.345,109.597,329.345z M333.597,329.345c-13.785,0-24.706-11.214-24.346-24.999c0.361-13.786,11.87-25.001,25.655-25.001c13.785,0,24.707,11.215,24.345,25.001C358.89,318.131,347.382,329.345,333.597,329.345z M396.457,282.588c-0.52,5.767-5.823,10.639-11.58,10.639h-6.727c-4.454-19.453-21.744-33.882-42.721-33.882c-20.977,0-39.022,14.429-44.494,33.882h-2.059c-2.542,0-4.81-0.953-6.389-2.685c-1.589-1.742-2.337-4.113-2.106-6.676l12.609-139.691l28.959,0.006l-4.59,50.852c-0.735,8.137,1.78,15.821,7.083,21.637c5.292,5.806,12.685,9.004,20.813,9.004h56.338L396.457,282.588z"/></svg>',

        'delivery-truck-5' => '<svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g><g><path d="M476.158,286.938l-13.259-53.035c3.625-0.77,6.345-3.986,6.345-7.839v-8.551c0-18.566-15.105-33.67-33.67-33.67h-60.392v-17.637c0-9.136-7.432-16.568-16.568-16.568H246.32l68.24-27.296c4.111-1.644,6.11-6.31,4.466-10.421c-1.644-4.11-6.307-6.111-10.421-4.466l-55.874,22.349c17.026-10.924,33.871-22.947,40.284-31.355c12.485-16.369,9.323-39.843-7.046-52.328c-16.369-12.486-39.843-9.323-52.328,7.046c-9.122,11.962-21.158,45.573-28.948,69.258c-7.79-23.683-19.826-57.296-28.948-69.258c-12.484-16.369-35.959-19.53-52.328-7.046c-16.369,12.484-19.53,35.958-7.046,52.328c6.413,8.409,23.257,20.431,40.284,31.355l-55.874-22.349c-4.113-1.647-8.777,0.355-10.421,4.466c-1.645,4.111,0.355,8.777,4.466,10.421l68.24,27.296H50.772c-9.136,0-16.568,7.432-16.568,16.568v145.37c0,4.427,3.589,8.017,8.017,8.017c4.427,0,8.017-3.589,8.017-8.017v-145.37c0-0.295,0.239-0.534,0.534-0.534h307.841c0.295,0,0.534,0.239,0.534,0.534v145.372c0,4.427,3.589,8.017,8.017,8.017c4.427,0,8.017-3.589,8.017-8.017v-9.088h94.566c0.009,0,0.016,0.002,0.025,0.002s0.017-0.001,0.026-0.001c11.636,0.009,21.516,7.647,24.908,18.171h-24.928c-4.427,0-8.017,3.589-8.017,8.017v17.102c0,13.851,11.268,25.119,25.119,25.119h9.086v35.273h-20.962c-6.886-19.882-25.787-34.205-47.982-34.205s-41.097,14.322-47.982,34.205h-3.86V345.78c0-4.427-3.589-8.017-8.017-8.017c-4.427,0-8.017,3.589-8.017,8.017v60.392H192.817c-6.886-19.882-25.787-34.205-47.982-34.205s-41.097,14.322-47.982,34.205H50.772c-0.295,0-0.534-0.239-0.534-0.534v-17.637h34.739c4.427,0,8.017-3.589,8.017-8.017s-3.589-8.017-8.017-8.017H8.017c-4.427,0-8.017,3.589-8.017,8.017s3.589,8.017,8.017,8.017h26.188v17.637c0,9.136,7.432,16.568,16.568,16.568h43.304c-0.002,0.178-0.014,0.355-0.014,0.534c0,27.995,22.777,50.772,50.772,50.772s50.772-22.777,50.772-50.772c0-0.18-0.012-0.356-0.014-0.534h180.67c-0.002,0.178-0.014,0.355-0.014,0.534c0,27.995,22.777,50.772,50.772,50.772c27.995,0,50.772-22.777,50.772-50.772c0-0.18-0.012-0.356-0.014-0.534h26.203c4.427,0,8.017-3.589,8.017-8.017v-85.511C512,307.564,496.423,290.022,476.158,286.938z M172.9,121.059c-31.623-19.651-41.003-28.692-43.78-32.334c-7.123-9.339-5.319-22.732,4.021-29.855c3.85-2.936,8.388-4.355,12.893-4.355c6.422,0,12.776,2.886,16.963,8.376c7.755,10.168,19.9,44.391,27.918,69.052C185.504,128.757,179.284,125.028,172.9,121.059z M218.473,131.942c8.018-24.66,20.163-58.882,27.917-69.052c7.123-9.339,20.516-11.142,29.855-4.02c9.34,7.123,11.143,20.516,4.021,29.855c-2.777,3.641-12.157,12.683-43.778,32.333C230.105,125.026,223.885,128.756,218.473,131.942z M375.182,199.875h60.392c9.725,0,17.637,7.912,17.637,17.637v0.534h-78.029V199.875z M375.182,286.456V234.08h71.235l13.094,52.376H375.182z M144.835,457.479c-19.155,0-34.739-15.584-34.739-34.739s15.584-34.739,34.739-34.739c19.155,0,34.739,15.584,34.739,34.739S163.99,457.479,144.835,457.479z M427.023,457.479c-19.155,0-34.739-15.584-34.739-34.739s15.584-34.739,34.739-34.739c19.155,0,34.739,15.584,34.739,34.739S446.178,457.479,427.023,457.479z M495.967,354.865h-9.086c-5.01,0-9.086-4.076-9.086-9.086v-9.086h18.171V354.865z"/></g></g><g><g><path d="M144.835,406.172c-9.136,0-16.568,7.432-16.568,16.568s7.432,16.568,16.568,16.568c9.136,0,16.568-7.432,16.568-16.568S153.971,406.172,144.835,406.172z"/></g></g><g><g><path d="M427.023,406.172c-9.136,0-16.568,7.432-16.568,16.568s7.432,16.568,16.568,16.568c9.136,0,16.568-7.432,16.568-16.568S436.159,406.172,427.023,406.172z"/></g></g><g><g><path d="M332.96,371.967H213.244c-4.427,0-8.017,3.589-8.017,8.017s3.589,8.017,8.017,8.017H332.96c4.427,0,8.017-3.589,8.017-8.017S337.388,371.967,332.96,371.967z"/></g></g><g><g><path d="M127.733,337.763H25.119c-4.427,0-8.017,3.589-8.017,8.017s3.589,8.017,8.017,8.017h102.614c4.427,0,8.017-3.589,8.017-8.017S132.16,337.763,127.733,337.763z"/></g></g><g><g><path d="M127.733,218.046H93.528c-4.427,0-8.017,3.589-8.017,8.017v68.409c0,4.427,3.589,8.017,8.017,8.017s8.017-3.589,8.017-8.017v-26.188h17.637c4.427,0,8.017-3.589,8.017-8.017s-3.589-8.017-8.017-8.017h-17.637V234.08h26.188c4.427,0,8.017-3.589,8.017-8.017C135.749,221.636,132.16,218.046,127.733,218.046z"/></g></g><g><g><path d="M190.822,272.043c8.023-5.255,13.337-14.317,13.337-24.602c0-16.209-13.186-29.395-29.395-29.395h-21.378c-4.427,0-8.017,3.589-8.017,8.017v68.409c0,4.427,3.589,8.017,8.017,8.017s8.017-3.589,8.017-8.017v-17.637h13.346l14.722,22.083c1.545,2.317,4.086,3.571,6.677,3.571c1.529,0,3.073-0.436,4.439-1.348c3.685-2.455,4.68-7.433,2.223-11.116L190.822,272.043z M174.764,260.802h-13.361V234.08h13.361c7.368,0,13.361,5.993,13.361,13.361C188.125,254.809,182.132,260.802,174.764,260.802z"/></g></g><g><g><path d="M256,286.456h-26.188v-18.198c0.177,0.012,0.354,0.027,0.534,0.027h17.102c4.427,0,8.017-3.589,8.017-8.017s-3.589-8.017-8.017-8.017h-17.102c-0.181,0-0.357,0.015-0.534,0.027V234.08H256c4.427,0,8.017-3.589,8.017-8.017c0-4.427-3.589-8.017-8.017-8.017h-34.205c-4.427,0-8.017,3.589-8.017,8.017v68.409c0,4.427,3.589,8.017,8.017,8.017H256c4.427,0,8.017-3.589,8.017-8.017S260.427,286.456,256,286.456z"/></g></g><g><g><path d="M315.858,286.456H289.67v-18.171h9.086c4.427,0,8.017-3.589,8.017-8.017s-3.589-8.017-8.017-8.017h-9.086V234.08h26.188c4.427,0,8.017-3.589,8.017-8.017c0-4.427-3.589-8.017-8.017-8.017h-34.205c-4.427,0-8.017,3.589-8.017,8.017v68.409c0,4.427,3.589,8.017,8.017,8.017h34.205c4.427,0,8.017-3.589,8.017-8.017S320.285,286.456,315.858,286.456z"/></g></g></svg>',

        'delivery-truck-6' => '<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 612 612" xml:space="preserve"><g><g><path d="M612,338.19v55.625c0,13.877-11.249,25.125-25.126,25.125h-26.885c-4.857-33.332-33.585-58.961-68.259-58.961c-34.59,0-63.317,25.629-68.175,58.961H195.162c-4.857-33.332-33.585-58.961-68.175-58.961s-63.318,25.629-68.175,58.961H25.143c-13.876,0-25.125-11.248-25.125-25.125V338.19H612z M173.067,203.958h-14.313l-5.259,27.155h13.945c9.292,0,16.996-6.363,16.996-17.004C184.436,207.631,180.159,203.958,173.067,203.958z M543.892,428.907c0,28.729-23.367,52.094-52.095,52.094c-28.811,0-52.178-23.367-52.178-52.094c0-28.811,23.367-52.178,52.178-52.178C520.524,376.729,543.892,400.097,543.892,428.907z M517.845,428.907c0-14.404-11.726-26.047-26.047-26.047c-14.405,0-26.048,11.643-26.048,26.047c0,14.322,11.643,26.049,26.048,26.049C506.119,454.956,517.845,443.229,517.845,428.907z M179.063,428.907c0,28.729-23.283,52.094-52.094,52.094s-52.094-23.367-52.094-52.094c0-28.811,23.284-52.178,52.094-52.178S179.063,400.097,179.063,428.907z M153.017,428.907c0-14.404-11.642-26.047-26.046-26.047c-14.406,0-26.047,11.643-26.047,26.047c0,14.322,11.642,26.049,26.047,26.049C141.375,454.956,153.017,443.229,153.017,428.907z M611.982,324.302H0V156.125c0-13.903,11.307-25.125,25.125-25.125h379.736c13.903,0,25.126,11.223,25.126,25.125v18.678h49.833c8.794,0,17.253,3.518,23.534,9.715l98.745,97.656c6.281,6.282,9.883,14.824,9.883,23.786V324.302z M89.184,228.545l4.646-24.586h34.245l2.568-13.577H80.866l-16.881,86.837H79.64l6.854-35.104h28.863l2.568-13.569H89.184z M180.772,240.649v-0.246c13.086-4.278,19.81-17.118,19.81-28.986c0-8.923-4.4-15.655-11.745-18.837c-3.541-1.586-7.828-2.2-12.473-2.2h-30.696l-16.874,86.836h15.769l6.241-32.413h15.655l11.009,32.413h16.874l-11.614-32.168C181.623,241.876,180.772,240.649,180.772,240.649z M277.113,190.381h-51.854l-16.996,86.837h53.932l2.568-13.577h-38.155l4.523-23.359h29.231l2.691-13.577h-29.231l4.4-22.746h36.201L277.113,190.381z M347.174,190.381h-51.855l-16.996,86.837h53.933l2.567-13.577h-38.155l4.523-23.359h29.231l2.691-13.577h-29.232l4.401-22.746h36.2L347.174,190.381z M561.731,278.655l-77.305-73.787c-0.754-0.669-1.759-1.088-2.764-1.088h-18.174c-2.178,0-3.937,1.759-3.937,3.937v73.787c0,2.178,1.759,3.936,3.937,3.936h95.562C562.568,285.439,564.327,281.084,561.731,278.655z"/></g></g></svg>',

        'delivery-truck-7' => '<svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 511.998 511.998" xml:space="preserve"><g><g><path d="M55.676,207.671H30.023c-4.523,0-8.188,3.666-8.188,8.188s3.665,8.188,8.188,8.188h25.653c4.523,0,8.188-3.666,8.188-8.188S60.199,207.671,55.676,207.671z"/></g></g><g><g><path d="M99.346,300.464H40.941c-4.523,0-8.188,3.666-8.188,8.188s3.665,8.188,8.188,8.188h58.406c4.523,0,8.188-3.666,8.188-8.188S103.87,300.464,99.346,300.464z"/></g></g><g><g><path d="M77.511,251.338H8.188c-4.523,0-8.188,3.666-8.188,8.188s3.665,8.188,8.188,8.188h69.323c4.523,0,8.188-3.666,8.188-8.188S82.034,251.338,77.511,251.338z"/></g></g><g><g><path d="M77.511,365.966h-6.715c-4.523,0-8.188,3.666-8.188,8.188c0,4.522,3.665,8.188,8.188,8.188h6.715c4.523,0,8.188-3.666,8.188-8.188C85.699,369.633,82.034,365.966,77.511,365.966z"/></g></g><g><g><path d="M43.502,365.966H8.188c-4.523,0-8.188,3.666-8.188,8.188c0,4.522,3.665,8.188,8.188,8.188h35.314c4.523,0,8.188-3.666,8.188-8.188C51.69,369.633,48.024,365.966,43.502,365.966z"/></g></g><g><g><path d="M427.771,159.128h-69.403v-14.739c0-4.522-3.665-8.188-8.188-8.188H246.016c-4.523,0-8.188,3.666-8.188,8.188s3.665,8.188,8.188,8.188h95.976v172.495c0,4.522,3.665,8.188,8.188,8.188c4.523,0,8.188-3.666,8.188-8.188V175.504h69.403c37.414,0,67.851,30.434,67.851,67.842v138.5h-20.818c-3.938-24.717-25.397-43.67-51.206-43.67c-25.808,0-47.268,18.953-51.205,43.67h-14.026v-29.48c0-4.522-3.665-8.188-8.188-8.188c-4.523,0-8.188,3.666-8.188,8.188v29.48h-86.901c-3.938-24.717-25.397-43.67-51.205-43.67s-47.268,18.953-51.206,43.67H135.65V262.43c0-4.522-3.665-8.188-8.188-8.188s-8.188,3.666-8.188,8.188v127.604c0,4.522,3.665,8.188,8.188,8.188h25.217c3.938,24.717,25.398,43.67,51.206,43.67s47.268-18.953,51.205-43.67h117.302c3.938,24.717,25.397,43.67,51.205,43.67s47.268-18.953,51.205-43.67h29.006c4.523,0,8.188-3.666,8.188-8.188V243.346C512,196.908,474.214,159.128,427.771,159.128z M203.885,425.516c-19.565,0-35.482-15.917-35.482-35.482c0-19.565,15.917-35.482,35.482-35.482c19.565,0,35.482,15.917,35.482,35.482C239.367,409.6,223.45,425.516,203.885,425.516z M423.6,425.516c-19.561,0-35.474-15.909-35.482-35.468c0-0.004,0.001-0.01,0.001-0.014c0-0.004-0.001-0.01-0.001-0.014c0.008-19.559,15.921-35.468,35.482-35.468c19.565,0,35.482,15.917,35.482,35.482C459.082,409.6,443.165,425.516,423.6,425.516z"/></g></g><g><g><path d="M479.248,243.346c0-28.378-23.092-51.465-51.476-51.465h-44.838c-4.523,0-8.188,3.666-8.188,8.188v76.969c0,4.522,3.665,8.188,8.188,8.188h88.128c4.523,0,8.188-3.666,8.188-8.188v-33.692H479.248z M391.121,268.851v-60.592h36.65c19.355,0,35.1,15.741,35.1,35.089v25.503H391.121z"/></g></g><g><g><path d="M203.885,368.925c-11.64,0-21.11,9.47-21.11,21.11c0,11.64,9.47,21.11,21.11,21.11c11.64,0,21.11-9.47,21.11-21.11C224.995,378.395,215.525,368.925,203.885,368.925z M203.885,394.768c-2.61,0-4.734-2.123-4.734-4.734c0-2.61,2.123-4.734,4.734-4.734c2.61,0,4.734,2.123,4.734,4.734C208.619,392.645,206.495,394.768,203.885,394.768z"/></g></g><g><g><path d="M423.6,368.925c-11.64,0-21.11,9.47-21.11,21.11c0,11.64,9.47,21.11,21.11,21.11c11.64,0,21.11-9.47,21.11-21.11C444.71,378.395,435.24,368.925,423.6,368.925z M423.6,394.768c-2.61,0-4.734-2.123-4.734-4.734c0-2.61,2.123-4.734,4.734-4.734c2.61,0,4.734,2.123,4.734,4.734C428.333,392.645,426.21,394.768,423.6,394.768z"/></g></g><g><g><path d="M471.06,307.607c-4.523,0-8.188,3.666-8.188,8.188v20.743c0,4.522,3.665,8.188,8.188,8.188c4.523,0,8.188-3.666,8.188-8.188v-20.743C479.248,311.273,475.582,307.607,471.06,307.607z"/></g></g><g><g><path d="M140.782,70.105c-11.045,0-21.812,2.041-32.003,6.064c-4.207,1.661-6.269,6.417-4.608,10.623c1.661,4.207,6.418,6.268,10.623,4.608c8.266-3.264,17.01-4.919,25.988-4.919c39.037,0,70.796,31.759,70.796,70.796s-31.759,70.796-70.796,70.796c-39.037,0-70.796-31.759-70.796-70.796c0-19.857,8.419-38.925,23.097-52.317c3.342-3.048,3.578-8.226,0.531-11.567c-3.049-3.341-8.229-3.578-11.568-0.531c-18.072,16.488-28.437,39.966-28.437,64.415c0.001,48.068,39.107,87.173,87.173,87.173c48.067,0,87.172-39.106,87.172-87.172C227.954,109.211,188.849,70.105,140.782,70.105z"/></g></g><g><g><path d="M161.004,149.089H148.97v-37.398c0-4.522-3.665-8.188-8.188-8.188s-8.188,3.666-8.188,8.188v45.586c0,4.522,3.665,8.188,8.188,8.188h20.223c4.523,0,8.188-3.666,8.188-8.188S165.527,149.089,161.004,149.089z"/></g></g></svg>',

        'delivery-truck-8' => '<svg fill="#000000" viewBox="0 -64 640 640" xmlns="http://www.w3.org/2000/svg"><path d="M624 352h-16V243.9c0-12.7-5.1-24.9-14.1-33.9L494 110.1c-9-9-21.2-14.1-33.9-14.1H416V48c0-26.5-21.5-48-48-48H112C85.5 0 64 21.5 64 48v48H8c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h272c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H40c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h208c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H8c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h208c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H64v128c0 53 43 96 96 96s96-43 96-96h128c0 53 43 96 96 96s96-43 96-96h48c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16zM160 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm320 0c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm80-208H416V144h44.1l99.9 99.9V256z"/></svg>',

        'delivery-truck-9' => '<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 35.632 35.632" xml:space="preserve"><g><path d="M20.777,5.002h8.539l0.713,1.13h-8.537L20.777,5.002z M24.679,4.271L23.71,2.671H12.116l0.969,1.599H24.679z M19.132,8.507l-1.475-2.804H0l1.474,2.804H19.132z M35.632,24.513v4.838h-3.037c-0.346,2.045-2.123,3.609-4.266,3.609c-2.142,0-3.921-1.564-4.265-3.609h-9.728c-0.346,2.045-2.123,3.609-4.266,3.609c-2.142,0-3.92-1.564-4.266-3.609H5.188v-7.336h10.871l-1.475-2.801H5.188v-2.021l-2.81-0.012l-0.961-1.604l3.771,0.017V9.991h18.978v2.802h7.896L35.632,24.513z M12.368,28.63c0-1.266-1.026-2.293-2.292-2.293c-1.265,0-2.292,1.027-2.292,2.293c0,1.264,1.027,2.293,2.292,2.293C11.341,30.923,12.368,29.894,12.368,28.63z M30.625,28.63c0-1.266-1.029-2.293-2.293-2.293s-2.293,1.027-2.293,2.293c0,1.264,1.029,2.293,2.293,2.293S30.625,29.894,30.625,28.63z M33.595,24.816l-3.036-9.983h-4.351v10.028c0.627-0.354,1.353-0.561,2.121-0.561c1.93,0,3.565,1.27,4.125,3.014h1.141V24.816L33.595,24.816z"/></g></svg>',

        'delivery-truck-10' => '<svg fill="#000000" width="800px" height="800px" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg"><path d="M15.48 12c-.13.004-.255.058-.347.152l-2.638 2.63-1.625-1.62c-.455-.474-1.19.258-.715.712l1.983 1.978c.197.197.517.197.715 0l2.995-2.987c.33-.32.087-.865-.367-.865zM.5 16h3c.277 0 .5.223.5.5s-.223.5-.5.5h-3c-.277 0-.5-.223-.5-.5s.223-.5.5-.5zm0-4h3c.277 0 .5.223.5.5s-.223.5-.5.5h-3c-.277 0-.5-.223-.5-.5s.223-.5.5-.5zm0-4h3c.277 0 .5.223.5.5s-.223.5-.5.5h-3C.223 9 0 8.777 0 8.5S.223 8 .5 8zm24 11c-1.375 0-2.5 1.125-2.5 2.5s1.125 2.5 2.5 2.5 2.5-1.125 2.5-2.5-1.125-2.5-2.5-2.5zm0 1c.834 0 1.5.666 1.5 1.5s-.666 1.5-1.5 1.5-1.5-.666-1.5-1.5.666-1.5 1.5-1.5zm-13-1C10.125 19 9 20.125 9 21.5s1.125 2.5 2.5 2.5 2.5-1.125 2.5-2.5-1.125-2.5-2.5-2.5zm0 1c.834 0 1.5.666 1.5 1.5s-.666 1.5-1.5 1.5-1.5-.666-1.5-1.5.666-1.5 1.5-1.5zm-5-14C5.678 6 5 6.678 5 7.5v11c0 .822.678 1.5 1.5 1.5h2c.676.01.676-1.01 0-1h-2c-.286 0-.5-.214-.5-.5v-11c0-.286.214-.5.5-.5h13c.286 0 .5.214.5.5V19h-5.5c-.66 0-.648 1.01 0 1h7c.66 0 .654-1 0-1H21v-9h4.227L29 15.896V18.5c0 .286-.214.5-.5.5h-1c-.654 0-.654 1 0 1h1c.822 0 1.5-.678 1.5-1.5v-2.75c0-.095-.027-.19-.078-.27l-4-6.25c-.092-.143-.25-.23-.422-.23H21V7.5c0-.822-.678-1.5-1.5-1.5z"/></svg>',

        'delivery-scooter' => '<svg fill="#000000" width="800px" height="800px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><path d="M12.37 7.53a3.67 3.67 0 0 0-2.5 1H7.16a.65.65 0 0 1-.38-.13L5 7V4h2V2.75H4.1a2.91 2.91 0 0 0-.33-.37 2.34 2.34 0 0 0-.77-.5 2.64 2.64 0 0 0-1-.18V4h1.75v3.16a.62.62 0 0 1-.09.32L2.19 9.93A2.38 2.38 0 0 0 0 12.2a2.41 2.41 0 0 0 2.5 2.3A2.41 2.41 0 0 0 5 12.2h11V11a3.54 3.54 0 0 0-3.63-3.47zm0 1.25A2.29 2.29 0 0 1 14.75 11H10a2.29 2.29 0 0 1 2.37-2.22zM2.5 13.25a1.16 1.16 0 0 1-1.25-1.05 1.16 1.16 0 0 1 1.25-1 1.16 1.16 0 0 1 1.25 1 1.16 1.16 0 0 1-1.25 1.05zM4.59 11a2.38 2.38 0 0 0-1.06-.83L4.62 8.3 6 9.36a1.9 1.9 0 0 0 1.13.38H9A3.22 3.22 0 0 0 8.75 11z"/><path d="M14.75 1.5H11a1.25 1.25 0 0 0-1.3 1.25v3A1.25 1.25 0 0 0 11 7h3.8A1.25 1.25 0 0 0 16 5.75v-3a1.25 1.25 0 0 0-1.25-1.25zm0 4.25H11v-3h3.8zm-2.38 7.5a1.17 1.17 0 0 1-1.25-1.05H9.87a2.41 2.41 0 0 0 2.5 2.3 2.41 2.41 0 0 0 2.5-2.3h-1.25a1.16 1.16 0 0 1-1.25 1.05z"/></svg>',

        'delivery-sent' => '<svg fill="#000000" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg"><g data-name="31 delivery box" id="_31_delivery_box"><path d="M32,3.5A19.7,19.7,0,0,0,12.32,23.18c0,.03.02.06.02.09a1.18,1.18,0,0,0,.04.2,1.336,1.336,0,0,0,.07.18,1.3,1.3,0,0,0,.1.15,1,1,0,0,0,.15.14.234.234,0,0,0,.07.07L28.7,34.63H17.43a2.006,2.006,0,0,0-2,2V58.5a2.006,2.006,0,0,0,2,2H46.57a2.006,2.006,0,0,0,2-2V36.63a2.006,2.006,0,0,0-2-2H35.3L51.23,24.01a.234.234,0,0,0,.07-.07,1,1,0,0,0,.15-.14,1.3,1.3,0,0,0,.1-.15,1.336,1.336,0,0,0,.07-.18,1.18,1.18,0,0,0,.04-.2c0-.03.02-.06.02-.09A19.7,19.7,0,0,0,32,3.5Zm0,2a17.694,17.694,0,0,1,15.68,9.52,10.243,10.243,0,0,0-6.34-2.18A10.347,10.347,0,0,0,32,18.75a10.347,10.347,0,0,0-9.34-5.91,10.243,10.243,0,0,0-6.34,2.18A17.694,17.694,0,0,1,32,5.5ZM14.35,22.66A8.333,8.333,0,0,1,31,23.18V33.76ZM34.11,36.63v8.55l-1.56-1.04a.975.975,0,0,0-1.1,0l-1.56,1.04V36.63Zm1.47,11.3a1,1,0,0,0,.53-.88V36.63H46.57V58.5H17.43V36.63H27.89V47.05a1,1,0,0,0,.53.88,1.009,1.009,0,0,0,1.02-.05L32,46.17l2.56,1.71a1.016,1.016,0,0,0,.55.17A.939.939,0,0,0,35.58,47.93ZM33,33.76V23.18a8.333,8.333,0,0,1,16.65-.52Z"/><path d="M43.42,50.2H37.19a1,1,0,0,0-1,1v4.15a1,1,0,0,0,1,1h6.23a1,1,0,0,0,1-1V51.2A1,1,0,0,0,43.42,50.2Zm-1,4.15H38.19V52.2h4.23Z"/></g></svg>',

        'delivery-express' => '<svg enable-background="new 0 0 512 512"fill=#000000 height=800px id=Express_x5F_mail version=1.1 viewBox="0 0 512 512"width=800px xml:space=preserve xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink><g><g><rect height=12.836 width=10 x=342.989 y=281.99 transform="matrix(0.5831 0.8124 -0.8124 0.5831 379.3777 -162.4696)"/><rect height=10 width=15.754 x=33.68 y=318.611 /><rect height=10 width=15.755 x=12.377 y=231.519 /><path d="M481.264,172.216c-10.822-39.862-47.328-68.533-89.738-68.533c-51.274,0-92.988,41.716-92.988,92.991    c0,12.128,2.268,23.814,6.748,34.845H110.883h-6.608H41.419v10h62.855v18.14H68.167v10h36.108v48.953h-43.19v10h43.19v17.318    H80.191v10h24.084v73.868h321.023V283.332c16.862-6.557,31.308-17.788,41.936-32.65l-8.134-5.818    c-8.717,12.189-20.311,21.634-33.802,27.628v-40.974H316.191c-5.077-10.926-7.654-22.632-7.654-34.845    c0-45.761,37.229-82.991,82.988-82.991c38.169,0,70.969,26.019,80.318,62.056l-17.575-10.014l-4.95,8.689l31.857,18.152    l18.447-32.372l-8.689-4.952L481.264,172.216z M404.754,241.519l-44.913,32.229l5.83,8.125l49.628-35.612v168.291l-104.161-81.224    l-6.149,7.886l100.775,78.584h-281.95l100.769-78.584l-6.149-7.886l-104.158,81.227V246.261l134.653,96.624    c4.743,3.404,10.301,5.105,15.859,5.105c5.56,0,11.119-1.701,15.862-5.105l54.986-39.459l-5.831-8.124l-54.985,39.458    c-6,4.305-14.062,4.307-20.062,0l-129.939-93.241H404.754z"/><path d="M307.505,133.801l-7.948-6.068c-15.486,20.284-23.671,44.528-23.671,70.111h10    C285.886,174.473,293.361,152.327,307.505,133.801z"/><path d="M335.381,108.341l-5.322-8.466c-6.842,4.301-13.258,9.343-19.07,14.983l6.966,7.176    C323.266,116.879,329.129,112.271,335.381,108.341z"/><path d="M391.527,92.202c19.936,0,39.348,5.58,56.141,16.135l5.322-8.466c-18.389-11.559-39.643-17.669-61.463-17.669    c-15.795,0-31.107,3.129-45.508,9.3l3.938,9.191C363.107,95.059,377.094,92.202,391.527,92.202z"/><path d=M473.717,116.493c-3.195-3.228-6.617-6.3-10.168-9.13l-6.232,7.82c3.246,2.587,6.372,5.396,9.293,8.346L473.717,116.493z /><path d="M387.02,128.683v53.931c-4.388,1.529-7.861,5.003-9.391,9.391h-38.583v10h38.583c2.076,5.957,7.735,10.25,14.391,10.25    c8.409,0,15.25-6.842,15.25-15.25c0-6.656-4.293-12.314-10.25-14.391v-53.931H387.02z M392.02,202.255    c-2.895,0-5.25-2.355-5.25-5.25c0-2.896,2.355-5.25,5.25-5.25c2.896,0,5.25,2.354,5.25,5.25    C397.27,199.899,394.915,202.255,392.02,202.255z"/><path d="M463.418,238.168l8.655,5.008c2.356-4.073,4.416-8.356,6.122-12.732l-9.316-3.632    C467.357,230.714,465.52,234.535,463.418,238.168z"/></g></g></svg>',

        'cart' => '<svg viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="icomoon-ignore"></g><path d="M30.622 9.602h-22.407l-1.809-7.464h-5.027v1.066h4.188l5.198 21.443c-1.108 0.323-1.923 1.334-1.923 2.547 0 1.472 1.193 2.666 2.666 2.666s2.666-1.194 2.666-2.666c0-0.603-0.208-1.153-0.545-1.599h7.487c-0.337 0.446-0.545 0.997-0.545 1.599 0 1.472 1.193 2.666 2.665 2.666s2.666-1.194 2.666-2.666c0-1.473-1.193-2.665-2.666-2.666v0h-11.403l-0.517-2.133h14.968l4.337-12.795zM13.107 27.196c0 0.882-0.717 1.599-1.599 1.599s-1.599-0.717-1.599-1.599c0-0.882 0.717-1.599 1.599-1.599s1.599 0.718 1.599 1.599zM24.836 27.196c0 0.882-0.718 1.599-1.6 1.599s-1.599-0.717-1.599-1.599c0-0.882 0.717-1.599 1.599-1.599 0.882 0 1.6 0.718 1.6 1.599zM11.058 21.331l-2.585-10.662h20.662l-3.615 10.662h-14.462z" fill="#000000"></path></svg>',

        'delivery-date' => '<svg version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g><path fill="#000000" d="M134.952,315.459c0-2.632,0.058-5.272,0.334-7.86h-31.239c-0.189,2.588-0.241,5.228-0.241,7.86c0,2.684,0.052,5.272,0.241,7.861h31.239C135.01,320.732,134.952,318.099,134.952,315.459z"/><path fill="#000000" d="M190.21,214.731c2.952-1.869,5.97-3.636,9.031-5.192l1.193-0.581l-15.568-27.044c-3.898,1.97-7.694,4.152-11.374,6.545l15.576,27.043L190.21,214.731z"/><path fill="#000000" d="M120.844,245.934l27.051,15.569l6.544-11.358l-27.058-15.576C124.996,238.256,122.815,242.037,120.844,245.934z"/><path fill="#000000" d="M360.31,370.593c-1.622,3.069-3.331,6.079-5.25,8.988l-0.778,1.142l27.058,15.576c2.385-3.686,4.567-7.417,6.589-11.314l-26.993-15.628L360.31,370.593z"/><path fill="#000000" d="M148.462,370.55l-0.625-1.193l-26.993,15.569c1.92,3.898,4.152,7.687,6.538,11.373l27.058-15.576l-0.785-1.142C151.785,376.672,150.026,373.662,148.462,370.55z"/><path fill="#000000" d="M190.21,416.137l-1.142-0.786l-15.576,27.058c3.68,2.392,7.475,4.617,11.374,6.595l15.568-27.051l-1.193-0.574C196.179,419.824,193.161,418.056,190.21,416.137z"/><path fill="#000000" d="M335.229,188.459c-3.679-2.393-7.431-4.574-11.307-6.545l-15.634,27l11.365,6.588L335.229,188.459z"/><path fill="#000000" d="M246.522,434.556v31.203c2.596,0.233,5.228,0.276,7.853,0.276c2.647,0,5.279-0.043,7.868-0.276v-31.203v-0.328h-15.721V434.556z"/><path fill="#000000" d="M262.243,196.37v-31.204c-2.589-0.232-5.221-0.283-7.868-0.283c-2.625,0-5.257,0.051-7.853,0.283v31.204v0.327h15.721V196.37z"/><path fill="#000000" d="M308.288,422.004l15.634,27c3.876-2.036,7.628-4.203,11.307-6.595l-15.576-27.058L308.288,422.004z"/><path fill="#000000" d="M387.928,245.934c-1.978-3.897-4.204-7.678-6.589-11.365l-27.058,15.576l6.603,11.358L387.928,245.934z"/><path fill="#000000" d="M404.726,307.599h-31.247h-0.328v15.721h0.328h31.247c0.188-2.588,0.232-5.221,0.232-7.861C404.958,312.827,404.915,310.187,404.726,307.599z"/><path fill="#000000" d="M442.146,148.275c0,0-0.85,16.26-16.434,23.182c-15.584,6.93-31.166-8.653-8.653-25.975c22.506-17.321,20.775-74.448,0-91.769c5.192,13.852-16.463,32.904-30.301,20.783c-13.86-22.513,0.858-59.744,21.64-70.129c-15.584-12.136-61.475,1.724-61.475,32.898c0,24.797,0.865,34.636-19.917,33.77c-22.746-0.96-3.454-39.841,0-45.034c-67.533,9.526-29.437,69.27-55.412,70.994c-25.974,1.738-10.384-25.961-8.653-29.436c-45.164,7.511-34.155,35.747-65.642,59.818c-80.702,24.454-139.45,99.39-139.457,188.09C57.849,424.019,145.83,511.993,254.375,512c108.553-0.007,196.534-87.981,196.541-196.534c0-25.08-4.748-49.033-13.307-71.089c2.138-26.404,11.649-42.583,14.834-55.687C459.577,159.371,442.146,148.275,442.146,148.275z M254.375,486.643c-47.31-0.007-90.024-19.139-121.038-50.138c-30.999-31.021-50.132-73.735-50.138-121.038c0.006-47.317,19.139-90.031,50.138-121.045c31.014-31,73.728-50.132,121.038-50.132c47.31,0,90.024,19.132,121.046,50.132c31,31.014,50.131,73.728,50.138,121.045c-0.007,47.303-19.139,90.017-50.138,121.038C344.399,467.504,301.685,486.636,254.375,486.643z"/><path fill="#000000" d="M321.348,233.645l-66.514,71.052l-51.353-35.754c-4.799-3.542-12.006-1.906-16.071,3.65c-4.065,5.541-3.462,12.9,1.36,16.434l58.058,44.794l0.8,0.465l0.371,0.196c5.025,2.8,11.664,1.316,16.092-3.563l0.386-0.378l71.161-84.192c4.058-4.538,4.13-11.067,0.181-14.58C331.87,228.264,325.391,229.108,321.348,233.645z"/></g></svg>',

        'delivery-man-1' => '<svg version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g><path fill="#000000" d="M447.77,33.653c-36.385-5.566-70.629,15.824-82.588,49.228h-44.038v37.899h40.902c5.212,31.372,29.694,57.355,62.855,62.436c41.278,6.316,79.882-22.042,86.222-63.341C517.428,78.575,489.07,39.969,447.77,33.653z"/><path fill="#000000" d="M162.615,338.222c0-6.88-5.577-12.468-12.468-12.468H96.16c-6.891,0-12.467,5.588-12.467,12.468c0,6.868,5.576,12.467,12.467,12.467h53.988C157.038,350.689,162.615,345.091,162.615,338.222z"/><path fill="#000000" d="M392.999,237.965L284.273,340.452l-37.966,9.398v-86.619H0v215.996h246.307v-59.454l35.547-5.732c16.95-2.418,29.396-6.692,44.336-15.018l46.302-24.228v104.432h132.435V270.828C504.927,202.618,428.016,202.43,392.999,237.965z M215.996,448.913H30.313v-155.37h185.683v63.805l-36.419,9.01c-15.968,4.395-25.708,20.518-22.174,36.696l0.298,1.247c3.478,15.912,18.651,26.436,34.785,24.14l23.51-3.788V448.913z"/></g></svg>',

        'airplane' => '<svg viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg"> <g id="Layer_2" data-name="Layer 2"> <g id="invisible_box" data-name="invisible box"> <rect width="48" height="48" fill="none"/> </g> <g id="Health_Icons" data-name="Health Icons"> <path d="M39,17H34.1l-7-13.2A2.8,2.8,0,0,0,24.4,2H16a3,3,0,0,0-2.5,1.3,2.8,2.8,0,0,0-.2,2.9L18,17H14.6l-1.2-2.3h0A3.4,3.4,0,0,0,10.5,13H5.2a3.5,3.5,0,0,0-2.8,1.5,3.1,3.1,0,0,0-.1,2.8L5.7,24,2.3,30.7a3.1,3.1,0,0,0,.1,2.8A3.5,3.5,0,0,0,5.2,35h5.3a3.4,3.4,0,0,0,2.9-1.6L14.6,31H18L13.3,41.8a2.8,2.8,0,0,0,.2,2.9A3,3,0,0,0,16,46h8.4a2.8,2.8,0,0,0,2.7-1.8l7-13.2H39a7,7,0,0,0,0-14Zm0,10H31.7L23.8,42H17.5l6.6-15h-12l-2,4H6.6l3.5-7L6.6,17h3.5l2,4h12L17.5,6h6.3l7.9,15H39a3,3,0,0,1,0,6Z"/> </g> </g></svg>',

        'package-1' => '<svg viewBox="0 0 1024 1024" class="icon"  version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M904.630857 240.054857c0.950857-9.435429-7.021714-19.382857-16.676571-24.283428L461.531429 2.633143a24.137143 24.137143 0 0 0-21.796572 0L13.531429 215.771429c-15.872 10.386286-13.385143 33.426286-13.385143 35.84V706.56c0 8.411429 4.388571 16.310857 11.702857 20.772571 0 0 417.060571 252.050286 424.228571 255.268572 14.628571 7.241143 23.844571 5.266286 30.72 1.755428L605.622857 904.045714c11.849143-6.948571 12.8-17.481143 11.264-35.693714-1.536-18.139429-17.408-28.013714-29.037714-21.284571-11.702857 6.656-103.497143 61.952-103.497143 61.952V493.568L852.114286 279.405714l38.692571-23.405714c7.68-4.973714 12.726857-11.337143 13.750857-15.945143z m-486.4 663.917714L63.780571 687.908571V290.230857L418.157714 493.714286v410.185143z m32.402286-476.525714L113.517714 236.324571 450.633143 67.876571l337.042286 168.448-337.042286 191.122286z m554.276571 335.872l-189.44 113.737143c-10.605714 7.387429-21.796571-0.877714-21.796571-0.877714-1.024-0.219429-188.635429-112.859429-188.635429-112.859429a18.139429 18.139429 0 0 1-8.850285-15.579428v-203.337143c0-6.582857 3.364571-18.066286 16.822857-23.259429l183.808-101.668571a18.870857 18.870857 0 0 1 16.091428 0l184.027429 101.668571h-1.462857c0.512 0 1.243429 0 1.755428 0.292572l4.754286 2.413714c5.997714 2.852571 11.556571 8.045714 11.556571 15.36v208.457143a18.432 18.432 0 0 1-8.630857 15.652571zM667.209143 540.818286l136.630857 76.726857 138.605714-76.726857L803.84 464.457143 667.209143 540.818286z m163.84 277.942857l139.702857-84.260572V582.802286l-139.702857 79.213714v156.672z m-49.517714-2.486857V662.747429l-136.996572-77.531429v148.48l136.996572 82.651429z" fill="#000000" /></svg>',

        'package-2' => '<svg fill="#000000" viewBox="0 0 100 100" data-name="Layer 1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"><path d="M69.61,84.17a1.5,1.5,0,0,1-.45-2.93l5.55-1.74a1.5,1.5,0,1,1,.9,2.86L70.06,84.1A1.41,1.41,0,0,1,69.61,84.17Z"/><path d="M50,90.25a1.46,1.46,0,0,1-1.5-1.46V40a1.49,1.49,0,0,1,1.05-1.43L87.43,26.76a1.52,1.52,0,0,1,1.34.22,1.51,1.51,0,0,1,.61,1.21V56.76a1.5,1.5,0,0,1-3,0V30.23L51.54,41.13V88.71A1.53,1.53,0,0,1,50,90.25Z"/><path d="M50,90.29a1.5,1.5,0,0,1-.45-2.93l19.57-6.12a1.5,1.5,0,1,1,.89,2.86L50.49,90.22A1.41,1.41,0,0,1,50,90.29Z"/><path d="M56,81.29a1.5,1.5,0,0,1-.45-2.93L69.38,74a1.5,1.5,0,1,1,.9,2.86L56.49,81.22A1.41,1.41,0,0,1,56,81.29Z"/><path d="M56,74.29a1.5,1.5,0,0,1-.45-2.93l10.53-3.29A1.5,1.5,0,1,1,67,70.93L56.49,74.22A1.41,1.41,0,0,1,56,74.29Z"/><path d="M50,90.21a1.31,1.31,0,0,1-.44-.07L11.7,78.3a1.49,1.49,0,0,1-1.06-1.43V28.11a1.5,1.5,0,0,1,1.5-1.5,1.43,1.43,0,0,1,.46.07l10.27,3.2a1.52,1.52,0,0,1,1.05,1.44V51.94a1.55,1.55,0,0,1,.15,1.3,1.52,1.52,0,0,1-1.92.92l-.23-.08a1.51,1.51,0,0,1-1-1.42V32.42l-7.28-2.28V75.77l34.9,10.9V41.05L40.37,38.5V58a1.5,1.5,0,0,1-3,0V36.46A1.5,1.5,0,0,1,39.31,35l11.18,3.5a1.48,1.48,0,0,1,1,1.43V88.71a1.48,1.48,0,0,1-.61,1.21A1.5,1.5,0,0,1,50,90.21Z"/><path d="M38.87,59.53a1.5,1.5,0,0,1-1.5-1.5V36.66a1.44,1.44,0,0,1,.05-.68,1.49,1.49,0,0,1,1.88-1,1.54,1.54,0,0,1,1.07,1.44V58A1.5,1.5,0,0,1,38.87,59.53Z"/><path d="M22.65,54.24a1.74,1.74,0,0,1-.5-.08l-.23-.08a1.51,1.51,0,0,1-1-1.42V31.32a1.5,1.5,0,0,1,3,0V51.94a1.55,1.55,0,0,1,.15,1.3A1.52,1.52,0,0,1,22.65,54.24Z"/><path d="M50,41.49A1.48,1.48,0,0,1,48.53,40V40a1.5,1.5,0,0,1,3,0A1.52,1.52,0,0,1,50,41.49Z"/><path d="M12.16,29.6a1.5,1.5,0,0,1-.58-2.88l38-15.82a1.5,1.5,0,0,1,1.16,2.77l-38,15.82A1.44,1.44,0,0,1,12.16,29.6Z"/><path d="M23.62,32.85A1.5,1.5,0,0,1,23,30l17.17-7.14a1.5,1.5,0,0,1,1.15,2.77L24.19,32.73A1.46,1.46,0,0,1,23.62,32.85Z"/><path d="M38.83,37.94A1.48,1.48,0,0,1,37.45,37a1.5,1.5,0,0,1,.8-2l15.12-6.29a1.5,1.5,0,0,1,1.16,2.77L39.41,37.83A1.49,1.49,0,0,1,38.83,37.94Z"/><path d="M61.75,18.66a1.51,1.51,0,0,1-.58-.12L49.62,13.66a1.5,1.5,0,1,1,1.16-2.76l11.56,4.88a1.5,1.5,0,0,1,.8,2A1.52,1.52,0,0,1,61.75,18.66Z"/><path d="M87.89,29.69a1.51,1.51,0,0,1-.58-.12l-26.14-11a1.5,1.5,0,1,1,1.17-2.76l26.14,11a1.5,1.5,0,0,1-.59,2.88Z"/><path d="M38.87,59.53a1.51,1.51,0,0,1-1.27-.7l-8-12.55a1.5,1.5,0,0,1,2.53-1.61l8,12.55a1.51,1.51,0,0,1-1.26,2.31Z"/><path d="M22.65,54.24a1.47,1.47,0,0,1-1.12-.51,1.49,1.49,0,0,1,.13-2.11l8.21-7.27a1.5,1.5,0,0,1,2,2.25l-8.21,7.26A1.45,1.45,0,0,1,22.65,54.24Z"/><path d="M54,31.65a1.5,1.5,0,0,1-.62-.13L40.2,25.59a1.5,1.5,0,0,1,1.23-2.73l13.14,5.92A1.5,1.5,0,0,1,54,31.65Z"/><path d="M81.88,84.2A15.16,15.16,0,1,1,97,69,15.18,15.18,0,0,1,81.88,84.2Zm0-27.32A12.16,12.16,0,1,0,94,69,12.17,12.17,0,0,0,81.88,56.88Z"/><path d="M80.29,75.42A1.53,1.53,0,0,1,79.22,75l-5.28-5.3a1.5,1.5,0,0,1,2.12-2.12l5.29,5.3a1.51,1.51,0,0,1,0,2.12A1.53,1.53,0,0,1,80.29,75.42Z"/><path d="M80.29,75.42a1.51,1.51,0,0,1-1.06-2.57l8.91-8.91a1.5,1.5,0,0,1,2.12,2.12L81.35,75A1.53,1.53,0,0,1,80.29,75.42Z"/></svg>',

        'package-3' => '<svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512.001 512.001" xml:space="preserve"><g><g><path d="M507.031,363.823c-0.873-4.359-5.109-7.184-9.476-6.311l-51.044,10.233l-22.385-111.659c-0.873-4.359-5.11-7.185-9.476-6.311c-4.359,0.874-7.184,5.117-6.311,9.476l22.385,111.658l-287.324,57.6l-40.722-203.124l51.045-10.234c6.177-1.239,8.574-9.126,4.107-13.588l-18.106-18.09l9.734-23.672c2.399-5.836-2.847-12.198-9.028-10.955l-51.044,10.233l-3.586-17.891l287.324-57.601l3.587,17.892l-51.045,10.234c-6.177,1.239-8.574,9.126-4.107,13.588l18.106,18.09l-9.734,23.672c-2.398,5.834,2.845,12.197,9.029,10.955l51.044-10.233l11.22,55.969c0.873,4.359,5.11,7.184,9.476,6.311c4.359-0.874,7.184-5.117,6.311-9.476L387.328,72.528c-0.86-4.293-5.177-7.178-9.476-6.311L82.635,125.401L60.586,15.417c-0.873-4.359-5.108-7.183-9.476-6.311L9.681,17.413c-4.359,0.874-7.184,5.117-6.311,9.476c0.873,4.359,5.107,7.183,9.476,6.311l33.534-6.723l82.813,413.094c0.858,4.289,5.178,7.177,9.476,6.311l158.754-31.826c-9.131,3.842-16.945,10.268-22.563,18.703c-7.548,11.335-10.232,24.932-7.555,38.285v-0.001c2.676,13.353,10.394,24.867,21.729,32.416c11.214,7.469,25.074,10.203,38.285,7.555c27.565-5.526,45.495-32.448,39.969-60.014c-4.839-24.133-26.08-40.88-49.791-40.968l183.22-36.731C505.079,372.426,507.906,368.184,507.031,363.823z M379.875,117.267l6.962,34.73l-36.295,7.277l6.055-14.723c1.236-3.007,0.543-6.461-1.756-8.757l-11.261-11.251L379.875,117.267z M92.552,174.867l36.295-7.276l-6.055,14.723c-1.235,3.007-0.543,6.461,1.756,8.757l11.261,11.251l-36.295,7.276L92.552,174.867z M351.506,454.164c3.779,18.861-8.487,37.281-27.349,41.063c-9.139,1.828-18.44-0.005-26.194-5.17c-7.756-5.165-13.037-13.041-14.868-22.178c0-0.001,0-0.001,0-0.001c-1.831-9.137,0.004-18.439,5.17-26.194c6.425-9.648,17.447-15.552,29.046-15.552C333.585,426.131,348.186,437.608,351.506,454.164z"/></g></g><g><g><path d="M342.032,456.061c-1.325-6.606-5.143-12.301-10.75-16.036c-5.607-3.734-12.33-5.061-18.94-3.738c-13.638,2.733-22.508,16.052-19.775,29.69v0.001c1.325,6.606,5.143,12.301,10.751,16.036c5.547,3.695,12.404,5.046,18.94,3.737c6.607-1.324,12.302-5.142,16.037-10.749C342.029,469.394,343.357,462.668,342.032,456.061z M324.894,466.078c-2.755,4.136-8.51,5.294-12.651,2.535c-2.029-1.35-3.409-3.41-3.889-5.799c-0.989-4.934,2.22-9.752,7.153-10.741c4.88-0.972,9.762,2.278,10.739,7.153C326.725,461.617,326.245,464.05,324.894,466.078z"/></g></g><g><g><path d="M185.314,244.399c-0.874-4.359-5.106-7.183-9.476-6.311l-42.099,8.44c-4.359,0.874-7.184,5.117-6.311,9.476l13.503,67.357c0.885,4.416,5.391,7.293,9.771,6.246c4.154-0.993,6.855-5.225,6.015-9.412l-5.169-25.785l17.366-3.481c4.36-0.873,7.185-5.117,6.312-9.475c-0.873-4.36-5.116-7.182-9.475-6.312l-17.367,3.481l-3.587-17.893l34.206-6.857C183.364,253.001,186.188,248.758,185.314,244.399z"/></g></g><g><g><path d="M263.646,293.834L243.64,275.95l9.473-1.9c4.359-0.874,7.184-5.117,6.311-9.476l-6.752-33.678c-0.873-4.359-5.107-7.182-9.476-6.311l-42.099,8.439c-4.295,0.86-7.174,5.176-6.311,9.476l13.503,67.357c0.885,4.416,5.391,7.293,9.771,6.246c4.154-0.993,6.855-5.225,6.015-9.412l-11.92-59.463l26.311-5.275l3.587,17.892l-17.367,3.481c-6.371,1.277-8.637,9.555-3.782,13.895l32.01,28.615c3.315,2.965,8.405,2.678,11.367-0.636C267.247,301.887,266.962,296.798,263.646,293.834z"/></g></g><g><g><path d="M333.534,284.75c-0.873-4.359-5.109-7.184-9.476-6.311l-25.784,5.168l-3.587-17.892l17.366-3.481c4.36-0.873,7.185-5.117,6.312-9.475c-0.873-4.36-5.114-7.186-9.475-6.312l-17.367,3.481l-3.587-17.892l25.785-5.17c4.359-0.874,7.184-5.117,6.311-9.476c-0.873-4.359-5.107-7.184-9.476-6.311l-33.679,6.752c-4.295,0.86-7.174,5.176-6.311,9.476l13.503,67.358c0.862,4.302,5.174,7.171,9.476,6.311l33.679-6.752C331.581,293.352,334.407,289.11,333.534,284.75z"/></g></g><g><g><path d="M392.471,272.937c-0.873-4.36-5.117-7.184-9.475-6.312l-25.784,5.167l-3.587-17.892l17.365-3.481c4.36-0.874,7.184-5.117,6.311-9.476c-0.873-4.359-5.108-7.183-9.476-6.311l-17.365,3.481l-3.587-17.892l25.784-5.169c4.359-0.874,7.184-5.117,6.311-9.476c-0.873-4.359-5.106-7.182-9.476-6.311l-33.678,6.752c-4.359,0.874-7.184,5.117-6.311,9.476l13.503,67.357c0.862,4.3,5.174,7.173,9.475,6.311l33.678-6.751C390.519,281.538,393.345,277.295,392.471,272.937z"/></g></g><g><g><path d="M313.258,139.929l-3.376-16.84c-0.86-4.293-5.176-7.18-9.476-6.312L165.69,143.784c-4.359,0.874-7.184,5.117-6.311,9.475l3.376,16.841c2.225,11.104,8.643,20.677,18.07,26.954c7.045,4.692,15.139,7.123,23.414,7.123c2.797,0,5.616-0.278,8.423-0.84l67.356-13.503c11.106-2.225,20.678-8.643,26.955-18.069C313.252,162.339,315.484,151.033,313.258,139.929z M293.575,162.839c-3.894,5.846-9.832,9.826-16.72,11.207l-67.358,13.504c-6.888,1.381-13.9-0.003-19.746-3.896c-5.847-3.894-9.827-9.831-11.207-16.718l-1.794-8.947l118.929-23.843l1.794,8.947C298.853,149.98,297.469,156.992,293.575,162.839z"/></g></g><g><g><path d="M170.222,387.555l-5.064-25.259c-0.873-4.359-5.106-7.185-9.476-6.311c-4.359,0.874-7.184,5.117-6.311,9.476l5.064,25.259c0.885,4.416,5.391,7.293,9.771,6.246C168.361,395.974,171.061,391.742,170.222,387.555z"/></g></g><g><g><path d="M203.901,380.804l-5.064-25.259c-0.873-4.359-5.107-7.181-9.476-6.311c-4.359,0.874-7.184,5.117-6.311,9.476l5.064,25.26c0.885,4.416,5.391,7.293,9.771,6.246C202.04,389.222,204.741,384.99,203.901,380.804z"/></g></g><g><g><path d="M246,372.362l-5.064-25.258c-0.874-4.358-5.108-7.182-9.476-6.311c-4.36,0.874-7.184,5.117-6.311,9.476l5.064,25.258c0.885,4.416,5.391,7.293,9.771,6.246C244.14,380.781,246.84,376.549,246,372.362z"/></g></g><g><g><path d="M288.098,363.923l-5.064-25.258c-0.873-4.359-5.109-7.182-9.476-6.311c-4.36,0.874-7.184,5.117-6.311,9.476l5.064,25.258c0.884,4.416,5.391,7.293,9.771,6.246C286.238,372.342,288.938,368.11,288.098,363.923z"/></g></g><g><g><path d="M321.777,357.173l-5.063-25.258c-0.873-4.36-5.114-7.185-9.475-6.312c-4.36,0.873-7.185,5.117-6.312,9.475l5.063,25.258c0.884,4.416,5.388,7.294,9.77,6.247C319.915,365.59,322.616,361.359,321.777,357.173z"/></g></g><g><g><path d="M347.037,352.109l-5.064-25.26c-0.873-4.359-5.108-7.181-9.476-6.311c-4.359,0.874-7.184,5.117-6.311,9.476l5.064,25.259c0.885,4.416,5.391,7.293,9.771,6.246C345.176,360.528,347.876,356.296,347.037,352.109z"/></g></g><g><g><path d="M372.295,347.045l-5.063-25.26c-0.873-4.359-5.117-7.183-9.475-6.312c-4.36,0.873-7.185,5.117-6.312,9.475l5.063,25.26c0.884,4.416,5.388,7.294,9.77,6.247C370.434,355.463,373.135,351.231,372.295,347.045z"/></g></g><g><g><path d="M405.975,340.293l-5.064-25.259c-0.873-4.359-5.107-7.184-9.476-6.311c-4.359,0.874-7.184,5.117-6.311,9.476l5.064,25.259c0.884,4.416,5.391,7.293,9.771,6.246C404.113,348.712,406.814,344.479,405.975,340.293z"/></g></g><g><g><path d="M200.184,34.349c-9.601,0-17.711-12.044-17.711-26.298c0-4.447-3.603-8.051-8.051-8.051s-8.051,3.603-8.051,8.051c0,14.255-8.111,26.298-17.711,26.298c-4.447,0-8.051,3.603-8.051,8.051s3.603,8.051,8.051,8.051c9.601,0,17.711,12.044,17.711,26.299c0,4.447,3.603,8.051,8.051,8.051s8.051-3.603,8.051-8.051c0-14.255,8.111-26.299,17.711-26.299c4.447,0,8.051-3.603,8.051-8.051S204.631,34.349,200.184,34.349z M174.422,49.316c-1.758-2.591-3.76-4.916-5.96-6.916c2.199-2,4.201-4.325,5.96-6.916c1.758,2.591,3.76,4.916,5.96,6.916C178.182,44.399,176.18,46.724,174.422,49.316z"/></g></g><g><g><path d="M500.739,197.507c-9.601,0-17.711-12.044-17.711-26.299c0-4.447-3.603-8.051-8.051-8.051s-8.051,3.603-8.051,8.051c0,14.255-8.111,26.299-17.711,26.299c-4.447,0-8.051,3.603-8.051,8.051s3.603,8.051,8.051,8.051c9.601,0,17.711,12.044,17.711,26.299c0,4.447,3.603,8.051,8.051,8.051s8.051-3.603,8.051-8.051c0-14.255,8.111-26.299,17.711-26.299c4.447,0,8.051-3.603,8.051-8.051S505.186,197.507,500.739,197.507z M474.977,212.474c-1.758-2.591-3.76-4.916-5.96-6.916c2.199-2,4.201-4.325,5.96-6.916c1.758,2.591,3.76,4.916,5.96,6.916C478.737,207.558,476.735,209.883,474.977,212.474z"/></g></g><g><g><path d="M62.788,360.665c-9.601,0-17.711-12.044-17.711-26.299c0-4.447-3.603-8.051-8.051-8.051s-8.051,3.603-8.051,8.051c0,14.255-8.111,26.299-17.711,26.299c-4.447,0-8.051,3.603-8.051,8.051s3.603,8.051,8.051,8.051c9.601,0,17.711,12.044,17.711,26.299c0,4.447,3.603,8.051,8.051,8.051s8.051-3.603,8.051-8.051c0-14.255,8.111-26.299,17.711-26.299c4.447,0,8.051-3.603,8.051-8.051S67.235,360.665,62.788,360.665z M37.026,375.632c-1.758-2.591-3.76-4.916-5.96-6.916c2.199-2,4.201-4.325,5.96-6.916c1.758,2.591,3.76,4.916,5.96,6.916C40.786,370.716,38.784,373.041,37.026,375.632z"/></g></g></svg>',

        'package-4' => '<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 612 612" xml:space="preserve"><g><path d="M172.227,387.451l-0.284-129.528c-0.014-5.901,6.015-9.891,11.44-7.571l109.174,46.669c3.017,1.29,4.976,4.251,4.984,7.532l0.284,129.529c0.014,5.9-6.015,9.891-11.441,7.57l-109.174-46.669C174.194,393.693,172.234,390.732,172.227,387.451z M433.512,249.1c4.331-0.011,8.216,3.472,8.228,8.202l0.284,129.529c0.008,3.28-1.938,6.251-4.949,7.556l-108.952,47.186c-1.074,0.466-2.176,0.683-3.248,0.686c-4.331,0.01-8.217-3.473-8.228-8.202l-0.284-129.528c-0.007-3.281,1.938-6.251,4.949-7.556l108.952-47.186C431.338,249.32,432.438,249.103,433.512,249.1L433.512,249.1z M305.226,163.638c1.135-0.003,2.271,0.229,3.333,0.698l114.863,50.636c6.517,2.873,6.538,12.111,0.035,15.014l-114.623,51.178c-1.06,0.473-2.194,0.711-3.329,0.714c-1.135,0.003-2.271-0.229-3.332-0.698l-114.864-50.636c-6.516-2.873-6.538-12.111-0.035-15.014l114.624-51.179C302.957,163.878,304.091,163.641,305.226,163.638L305.226,163.638z M331.597,537.555v-62.06h-51.083v62.06h-48.937L306.047,612l74.481-74.445H331.597z M537.555,280.403h-62.06v51.083h62.06v48.937L612,305.953l-74.445-74.482V280.403z M280.403,74.445v62.06h51.083v-62.06h48.937L305.953,0l-74.482,74.445H280.403z M74.445,331.597h62.06v-51.083h-62.06v-48.937L0,306.047l74.445,74.481V331.597z"/></g></svg>',

        'gift-box-1' => '<svg height="800px" width="800px" version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"> <style type="text/css"> .st0{fill:#000000;} </style> <g> <path class="st0" d="M482.429,142.558l-52.057-22.034c-4.959,4.637-12.082,8.869-22.244,10.566 c-1.718,0.286-3.848,0.496-6.293,0.656l57.715,24.429l-45.926,19.436c5.573,3.68,10.14,6.558,13.199,8.45 c0.475,0.287,0.88,0.628,1.32,0.943l39.382-16.67v70.347l-86.906,36.784c-0.349,1.369-0.642,2.493-0.81,3.01 c-2.906,9.225-11.314,15.42-20.896,15.42c-4.547,0-8.982-1.39-12.732-3.855l-86.62,36.664v-70.347l41.666-17.634 c-3.003-4.03-5.797-7.976-8.548-11.914l-40.269,17.04l-34.737-14.708c-2.78,3.926-5.643,7.864-8.674,11.873l36.26,15.344v70.347 l-82.59-34.954c-2.989,1.362-6.244,2.144-9.575,2.144c-9.435,0-17.676-6.006-20.72-14.973l-68.846-29.136v-0.461l-19.052-8.066 v-69.894l36.93,15.63c1.146-1.055,2.361-2.06,3.743-2.912c2.535-1.565,6.118-3.82,10.406-6.628l-44.5-18.835l63.035-26.678 c-5.503-0.188-8.422-0.552-10.203-0.852c-9.247-1.544-15.93-5.189-20.819-9.316l-60.047,25.414v108.291l19.052,8.066v158.762 L253.996,512l215.931-91.39V261.68l19.052-8.059V145.33L482.429,142.558z M245.259,485.001L63.527,408.088v-142.77l181.732,76.92 V485.001z M448.473,406.391l-188.911,79.958v-144.11l188.911-79.965V406.391z"/> <path class="st0" d="M106.931,112.751c12.236,2.032,61.527-0.572,98.003-2.898c-37.447,43.418-92.199,79.042-109.994,90.034 c-3.709,2.298-1.921,5.462,0.349,6.181c2.277,0.712,39.808,17.222,39.808,17.222c2.193,0.95,3.806,2.884,4.358,5.21 c0,0,9.407,41.037,10.462,44.375c1.054,3.338,4.77,2.758,6.397,1.082c59.767-61.499,86.466-121.161,97.333-152.442 c0.782,0.056,1.564,0.119,2.36,0.119c0.79,0,1.565-0.063,2.347-0.119c10.866,31.281,37.572,90.943,97.332,152.442 c1.634,1.676,5.343,2.256,6.397-1.082c1.055-3.338,10.462-44.375,10.462-44.375c0.552-2.326,2.165-4.26,4.358-5.21 c0,0,37.531-16.51,39.808-17.222c2.27-0.72,4.058-3.883,0.349-6.181c-17.808-10.992-72.652-46.686-110.092-90.16 c35.848,2.361,85.649,5.098,98.101,3.024c20.008-3.338,21.119-22.229,18.891-30.008c-1.599-5.573-20.128-52.889-37.782-73.351 c-7.025-8.15-21.119-13.339-31.12-5.559c-19.582,15.232-50.15,40.199-66.639,53.719c-4.19-10.294-13.143-18.074-32.412-18.074 c-19.624,0-28.57,8.052-32.67,18.619c-14.868-12.466-45.842-38.271-66.395-54.264c-10-7.78-24.094-2.591-31.12,5.559 C108.168,29.854,89.64,77.169,88.04,82.742C85.813,90.522,86.923,109.413,106.931,112.751z"/> </g> </svg>',

        'gift-box-2' => '<svg width="800px" height="800px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="#000000"><path d="M32 20c-6 0-12 0-12-6a6 6 0 0 1 6-6c6 0 6 8 6 12z"/><path d="M32 20c6 0 12 0 12-6a6 6 0 0 0-6-6c-6 0-6 8-6 12z"/><polyline points="12 32 12 56 52 56 52 32"/><rect x="8" y="20" width="48" height="12"/><line x1="32" y1="20" x2="32" y2="56"/></svg>',

        'gift-box-3' => '<svg width="800px" height="800px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg" stroke-width="3" stroke="#000000" fill="none"><polyline points="37.27 31.01 50.84 31.01 50.84 56.16 13.19 56.16 13.19 31.01 26.76 31.01" stroke-linecap="round"/><path d="M26.76,31H10.58a1,1,0,0,1-1-1v-5.2a1,1,0,0,1,1-1H53.42a1,1,0,0,1,1,1V30a1,1,0,0,1-1,1H37.27" stroke-linecap="round"/><path d="M45.73,9.86a6.5,6.5,0,0,0-3.51-1.6c-5.29-.57-7.08,8.12-9.7,14.33a.5.5,0,0,0,.65.65c6.17-2.62,14.46-4.47,14.33-9.69A5.3,5.3,0,0,0,45.73,9.86Z" stroke-linecap="round"/><path d="M21.79,7.86a6.44,6.44,0,0,0-3.5,1.6,5.32,5.32,0,0,0-1.78,3.69c-.13,5.22,8.16,7.07,14.33,9.69a.5.5,0,0,0,.65-.65C28.87,16,27.08,7.29,21.79,7.86Z" stroke-linecap="round"/><polygon points="37.27 45.78 32 42.78 26.76 45.78 26.76 23.77 37.27 23.77 37.27 45.78" stroke-linecap="round"/></svg>',

        'gift-box-4' => '<svg fill="#000000" height="800px" width="800px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 464.316 464.316" xml:space="preserve"> <g> <g> <path d="M449.409,155.756l-17.044-44.168c-3.384-8.776-12.668-15.148-22.08-15.148H56.777c-9.52,0-18.136,5.656-21.92,14.392 l-19.356,44.656c-3.14,7.252,1.436,15.904,10.104,16.772c5.156,0.52,9.972-2.728,12.032-7.484l19.108-44.092 c0.124-0.08,1.184-0.288,1.308-0.368h352l17.036,44.268c1.84,4.764,6.384,7.684,11.2,7.684c2.608,0,5.308-0.86,7.7-2.76 C450.053,166.28,451.277,160.6,449.409,155.756z"/> </g> </g> <g> <g> <path d="M402.053,288.316H258.285c-6.628,0-8.232,5.372-8.232,12s1.604,12,8.232,12h143.768c2.168,0,4,1.832,4,4v120 c0,2.168-1.832,4-4,4h-344c-2.168,0-4-1.832-4-4v-120c0-2.168,1.832-4,4-4h140.232c6.628,0,12-5.372,12-12s-5.372-12-12-12H58.053 c-15.436,0-28,12.564-28,28v120c0,15.436,12.564,28,28,28h344c15.44,0,28-12.56,28-28v-120 C430.053,300.88,417.489,288.316,402.053,288.316z"/> </g> </g> <g> <g> <path d="M437.821,148.316c-6.628,0-11.768,5.372-11.768,12v120c0,2.168-2.064,4-4.232,4H262.053c-6.628,0-12,5.372-12,12 s5.372,12,12,12h159.768c15.44,0,28-12.56,28-28v-120C449.821,153.688,444.449,148.316,437.821,148.316z"/> </g> </g> <g> <g> <path d="M202.053,284.316H41.821c-2.168,0-4-1.832-4-4v-120c0-6.628-5.372-12-12-12s-11.768,5.372-11.768,12v120 c0,15.436,12.332,28,27.768,28h160.232c6.628,0,12-5.372,12-12S208.681,284.316,202.053,284.316z"/> </g> </g> <g> <g> <path d="M437.821,164.316H258.053c-4.416,0-8,3.58-8,8c0,4.416,3.584,8,8,8h179.768c4.42,0,8-3.58,8-8 S442.237,164.316,437.821,164.316z"/> </g> </g> <g> <g> <path d="M206.053,164.316H25.821c-4.416,0-8,3.58-8,8c0,4.416,3.584,8,8,8h180.232c4.416,0,8-3.58,8-8 S210.469,164.316,206.053,164.316z"/> </g> </g> <g> <g> <path d="M258.053,120.316h-52c-4.416,0-8,3.58-8,8v316c0,4.416,3.584,8,8,8h52c4.416,0,8-3.58,8-8v-316 C266.053,123.896,262.469,120.316,258.053,120.316z M250.053,436.316h-36v-300h36V436.316z"/> </g> </g> <g> <g> <path d="M339.185,15.288C329.325,5.432,316.221,0,302.281,0c-13.944,0-27.048,5.428-36.904,15.284 c-16.86,16.856-41.8,90.656-46.628,105.276c-1.42,4.304-0.296,9.044,2.912,12.248c2.284,2.288,5.352,3.516,8.484,3.516 c1.264,0,2.532-0.196,3.764-0.604c14.624-4.828,88.42-29.772,105.276-46.628c9.856-9.86,15.28-22.964,15.28-36.904 S349.041,25.144,339.185,15.288z M322.217,72.124c0,0,0,0-0.004,0c-7.456,7.456-41.74,21.604-72.628,32.768 c11.16-30.888,25.304-65.172,32.768-72.636c5.324-5.324,12.4-8.256,19.932-8.256c7.524,0,14.604,2.932,19.932,8.264 c5.324,5.32,8.252,12.4,8.252,19.928C330.469,59.72,327.541,66.8,322.217,72.124z"/> </g> </g> <g> <g> <path d="M245.773,120.56c-4.828-14.62-29.768-88.42-46.628-105.272c-20.344-20.352-53.46-20.352-73.804,0 c-20.344,20.348-20.344,53.456,0,73.804c16.856,16.856,90.652,41.8,105.276,46.628c1.232,0.408,2.5,0.604,3.76,0.604 c3.132,0,6.2-1.228,8.484-3.516C246.069,129.604,247.193,124.864,245.773,120.56z M142.313,72.12 c-10.992-10.992-10.992-28.872-0.004-39.864c5.496-5.492,12.712-8.24,19.932-8.24c7.22,0,14.436,2.744,19.936,8.236v0.004 c7.46,7.456,21.604,41.744,32.768,72.632C184.061,93.728,149.773,79.584,142.313,72.12z"/> </g> </g> </svg>',

        'gift-box-5' => '<svg enable-background="new 0 0 512 512"fill=#000000 height=800px version=1.1 viewBox="0 0 512 512"width=800px xml:space=preserve xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink><g id=Layer_1 /><g id=Layer_2><g><path d="M400.2,170.1h-89.4c13.9-10,22.5-23.7,23.6-36.9c1.2-13.9-6.6-30.3-31.7-34.5c-2.8-0.5-5.6-0.7-8.3-0.7    c-10.9,0-19.9,4-26.7,11.8c-6.4,7.3-9.9,17.2-11.8,27.2c-1.9-10-5.5-20-11.8-27.2C237.4,102,228.4,98,217.5,98    c-2.6,0-5.4,0.2-8.3,0.7c-25.1,4.2-32.8,20.6-31.7,34.5c1.1,13.2,9.8,26.9,23.6,36.9h-89.4c-12.5,0-22.6,10.1-22.6,22.6V207    c0,12.5,10.1,22.6,22.6,22.6h6.6v156.4c0,15.5,12.6,28.1,28.1,28.1h219.1c15.5,0,28.1-12.6,28.1-28.1V229.6h6.6    c12.5,0,22.6-10.1,22.6-22.6v-14.3C422.8,180.2,412.7,170.1,400.2,170.1z M279.1,119.6c3.9-4.5,8.9-6.6,15.4-6.6    c1.8,0,3.8,0.2,5.8,0.5c7.6,1.3,20.3,5.4,19.2,18.5c-1.2,14.5-19.6,35.1-50.2,37.8C268.3,155.7,269,131.3,279.1,119.6z M192.5,132    c-1.1-13.1,11.6-17.2,19.2-18.5c2-0.3,4-0.5,5.8-0.5c6.5,0,11.5,2.2,15.4,6.6c10.1,11.6,10.8,36,9.8,50.2    C212.1,167.1,193.7,146.5,192.5,132z M378.6,385.9c0,7.2-5.9,13.1-13.1,13.1H146.4c-7.2,0-13.1-5.9-13.1-13.1V229.6h245.2V385.9z     M407.8,207c0,4.2-3.4,7.6-7.6,7.6h-14.1H125.9h-14.1c-4.2,0-7.6-3.4-7.6-7.6v-14.3c0-4.2,3.4-7.6,7.6-7.6h288.4    c4.2,0,7.6,3.4,7.6,7.6V207z"/><path d="M216.8,301.9c14.8,0,26.8-12,26.8-26.8c0-14.8-12-26.8-26.8-26.8s-26.8,12-26.8,26.8C190,289.9,202,301.9,216.8,301.9z     M216.8,263.3c6.5,0,11.8,5.3,11.8,11.8s-5.3,11.8-11.8,11.8s-11.8-5.3-11.8-11.8S210.3,263.3,216.8,263.3z"/><path d="M295.2,326.6c-14.8,0-26.8,12-26.8,26.8s12,26.8,26.8,26.8s26.8-12,26.8-26.8S310,326.6,295.2,326.6z M295.2,365.3    c-6.5,0-11.8-5.3-11.8-11.8s5.3-11.8,11.8-11.8s11.8,5.3,11.8,11.8S301.7,365.3,295.2,365.3z"/><path d="M197.4,372.9c1.5,1.5,3.4,2.2,5.3,2.2s3.8-0.7,5.3-2.2l106.6-106.6c2.9-2.9,2.9-7.7,0-10.6c-2.9-2.9-7.7-2.9-10.6,0    L197.4,362.3C194.4,365.2,194.4,370,197.4,372.9z"/></g></g></svg>',

        'gift-box-6' => '<svg width="800px" height="800px" version="1.1" viewBox="0 0 399.18 399.18" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><path d="m398.44 112.98-6.883-43.621c-1.435-9.089-9.766-16.209-18.967-16.209h-48.312c1.664-11.167 0.878-21.388-7.706-26.835-2.007-1.289-4.495-1.942-7.395-1.942-12.349 0-37.722 12.992-61.97 28.777h-95.236c-24.248-15.785-49.62-28.777-61.969-28.777-2.899 0-5.388 0.653-7.36 1.921-8.603 5.459-9.4 15.677-7.737 26.856h-48.317c-9.201 0-17.532 7.12-18.967 16.209l-6.883 43.621c-0.977 6.186-0.99 15.883-0.03 22.077l6.938 44.789c1.397 9.022 9.581 16.095 18.693 16.223 9e-3 0.104 7e-3 0.208 0.019 0.313l18.658 165.8c0.797 7.078 7.001 12.623 14.124 12.623h280.9c7.123 0 13.327-5.545 14.124-12.623l18.658-165.8c0.012-0.104 0.01-0.208 0.019-0.313 9.112-0.128 17.296-7.201 18.692-16.222l6.939-44.791c0.96-6.193 0.946-15.891-0.03-22.076zm-92.413-46.356c-2.366 9.164-4.325 17.389-4.325 25.231 0 7.896 1.509 18.061 3.327 29.542 1.336 8.599 3.083 19.846 3.272 26.995-5.304-0.072-14.742-5.188-24.729-10.601-2.244-1.217-4.562-2.473-6.936-3.731-12.883-6.864-29.001-17.249-37.843-23.089v-8.477l43.804-5.436c4.11-0.511 7.029-4.256 6.52-8.367-0.511-4.111-4.26-7.021-8.367-6.52l-41.956 5.206v-10.273c33.695-24.422 62.031-37.505 70.176-37.729 2.972 3.536-1.002 19.465-2.943 27.249zm-215.8-27.249c8.161 0.236 36.483 13.318 70.162 37.729v12.809c-1.089-0.951-2.463-1.597-4.005-1.789l-47.951-5.95c-4.101-0.497-7.856 2.409-8.367 6.52-0.51 4.111 2.409 7.856 6.52 8.367l47.951 5.95c0.313 0.038 0.625 0.058 0.934 0.058 1.856 0 3.588-0.689 4.919-1.849v9.753c-8.842 5.84-24.958 16.224-37.831 23.082-2.387 1.267-4.705 2.522-6.95 3.74-9.987 5.413-19.423 10.528-24.726 10.599 0.189-7.148 1.937-18.393 3.269-26.973 1.822-11.504 3.331-21.669 3.331-29.564 0-7.843-1.959-16.067-4.31-25.172-1.954-7.827-5.917-23.717-2.946-27.31zm70.24 320.43h-100.62l-18.312-162.72h118.93v162.72zm-133.87-178.72c-1.803 0-3.843-1.749-4.119-3.531l-6.938-44.789c-0.721-4.649-0.709-12.8 0.023-17.443l6.884-43.621c0.282-1.79 2.338-3.547 4.15-3.547h51.487c0.185 0.745 0.369 1.487 0.553 2.225 2.105 8.155 3.849 15.4 3.849 21.481 0 6.804-1.425 16.352-3.149 27.239-2.244 14.447-3.922 26.171-3.353 33.775-0.125 3.189 1.656 5.188 2.484 5.939 3.35 3.041 7.489 4.584 12.304 4.584h3e-3c9.084 0 19.191-5.478 31.985-12.413 2.206-1.195 4.484-2.431 6.843-3.682 10.006-5.331 21.771-12.627 30.868-18.475v52.257h-133.87zm192.87 178.17h-44v-291.1h44v291.1zm119.87 0.555h-104.87v-162.72h123.18l-18.312 162.72zm44.313-227.05-6.939 44.791c-0.275 1.781-2.315 3.53-4.118 3.53h-138.13v-55.011c9.431 6.148 23.471 15.021 35.134 21.236 2.346 1.243 4.623 2.478 6.828 3.674 12.797 6.936 22.904 12.414 31.99 12.414 4.814 0 8.954-1.542 12.3-4.58 0.832-0.754 2.611-2.751 2.489-5.939 0.57-7.604-1.108-19.329-3.356-33.802-1.721-10.865-3.146-20.413-3.146-27.217 0-6.081 1.743-13.326 3.864-21.541 0.179-0.718 0.359-1.44 0.538-2.165h51.486c1.813 0 3.868 1.757 4.15 3.547l6.883 43.621c0.734 4.643 0.745 12.794 0.026 17.442z" fill="#010202"/></svg>',
    ];

    /**
     * Gets the SVG code for a given icon.
     *
     * @static
     *
     * @since 2.6.0
     *
     * @param string $icon  The icon.
     * @param int    $size  The icon-size in pixels.
     * @return string
     */
    public static function get_svg($icon, $size)
    {
        $arr = self::$icons;

        $svg = '';
        if (array_key_exists($icon, $arr)) {
            $repl = sprintf('<svg class="fsl-svg-icon" width="%d" height="%d" aria-hidden="true" role="img" focusable="false" ', $size, $size);

            $svg = preg_replace('/^<svg /', $repl, trim($arr[$icon])); // Add extra attributes to SVG code.
        }

        // @phpstan-ignore-next-line.
        return $svg;
    }

    /**
     * Gets SVG icons array.
     *
     * @static
     *
     * @since 2.6.0
     *
     * @return array
     */
    public static function get_all()
    {
        return self::$icons;
    }
}
